/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.taxatree;

import edu.msu.cme.rdp.taxatree.Node;
import edu.msu.cme.rdp.taxatree.TaxonHolder;
import edu.msu.cme.rdp.taxatree.interfaces.TreeVisitor;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcretRoot<E extends Node> {
    protected TaxonHolder<E> root;
    protected Map<Integer, TaxonHolder<E>> taxonMap = new HashMap<Integer, TaxonHolder<E>>();

    public ConcretRoot(E rootTaxon) {
        this.root = new TaxonHolder<E>(rootTaxon);
        this.taxonMap.put(((Node)rootTaxon).getTaxid(), this.root);
    }

    public int getRootTaxid() {
        return ((Node)this.root.getTaxon()).getTaxid();
    }

    public TaxonHolder<E> getRootTaxonHodler() {
        return this.root;
    }

    public TaxonHolder<E> getChild(int txid) {
        return this.taxonMap.get(txid);
    }

    public E getChildTaxon(int txid) {
        TaxonHolder<E> holder = this.taxonMap.get(txid);
        if (holder == null) {
            return null;
        }
        return holder.getTaxon();
    }

    public void addChild(E child, int parentId) {
        if (!this.taxonMap.containsKey(parentId)) {
            throw new IllegalArgumentException("Failed to find parent with taxid=" + parentId + " in tree");
        }
        TaxonHolder<E> parentHolder = this.taxonMap.get(parentId);
        TaxonHolder<E> childHolder = new TaxonHolder<E>(child, parentHolder);
        parentHolder.addChild(childHolder);
        this.taxonMap.put(((Node)child).getTaxid(), childHolder);
    }

    public void topDownVisit(TreeVisitor<E> visitor) {
        this.root.topDownVisit(visitor);
    }

    public void biDirectionDepthFirst(TreeVisitor visitor) {
        this.root.biDirectionDepthFirst(visitor);
    }
}

