/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.utils.gbregion;

import edu.msu.cme.rdp.readseq.utils.gbregion.Extends;
import edu.msu.cme.rdp.readseq.utils.gbregion.SingleSeqRegion;

public class SimpleRegion
extends SingleSeqRegion {
    private String id;
    private int seqStart;
    private int seqStop;
    private Extends e;

    public SimpleRegion(String id, int start, int stop, Extends e) {
        this.id = id;
        if (start < stop) {
            this.seqStart = start;
            this.seqStop = stop;
        } else {
            this.seqStart = stop;
            this.seqStop = start;
        }
        this.e = e;
    }

    public String toString() {
        String ret = "";
        if (this.id != null && !this.id.equals("")) {
            ret = ret + this.id + ":";
        }
        if (this.seqStart == this.seqStop) {
            if (this.e == Extends.BEYOND_BEGIN) {
                ret = ret + "<";
            } else if (this.e == Extends.BEYOND_END) {
                ret = ret + ">";
            }
            ret = ret + this.seqStart;
        } else {
            if (this.e == Extends.BEYOND_BEGIN || this.e == Extends.BEYOND_BOTH) {
                ret = ret + "<";
            }
            ret = ret + this.seqStart + "..";
            if (this.e == Extends.BEYOND_END || this.e == Extends.BEYOND_BOTH) {
                ret = ret + ">";
            }
            if (this.seqStart != this.seqStop) {
                ret = ret + this.seqStop;
            }
        }
        return ret;
    }

    public String getId() {
        return this.id;
    }

    public int getSeqStart() {
        return this.seqStart;
    }

    public int getSeqStop() {
        return this.seqStop;
    }

    public String getSeqRegion(String seq, int offset) {
        if (this.seqStart < offset) {
            throw new IllegalArgumentException("Seq's offset (" + offset + ") is more than my start (" + this.seqStart + ") [" + this.toString() + "]");
        }
        return seq.substring(this.seqStart - offset, this.seqStop - offset + 1);
    }

    public Extends getExtends() {
        return this.e;
    }
}

