/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.readers;

import edu.msu.cme.rdp.readseq.SequenceFormat;
import edu.msu.cme.rdp.readseq.readers.SeqReader;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.SequenceReader;
import java.io.File;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiFileSeqReader
implements SeqReader {
    private final List<File> inputFiles;
    private SeqReader currReader;
    private int seqFileIndex;

    public MultiFileSeqReader(List<File> inputFiles) throws IOException {
        this.inputFiles = inputFiles;
        this.reset();
    }

    public Sequence readNextSequence() throws IOException {
        Object ret;
        if (this.currReader == null && !this.nextReader()) {
            return null;
        }
        while ((ret = this.currReader.readNextSequence()) == null && this.nextReader()) {
        }
        return ret;
    }

    private boolean nextReader() throws IOException {
        this.close();
        if (this.seqFileIndex >= this.inputFiles.size()) {
            return false;
        }
        this.currReader = new SequenceReader(this.inputFiles.get(this.seqFileIndex++));
        return true;
    }

    @Override
    public SequenceFormat getFormat() {
        if (this.currReader != null) {
            return this.currReader.getFormat();
        }
        return SequenceFormat.UNKNOWN;
    }

    @Override
    public void close() throws IOException {
        if (this.currReader != null) {
            this.currReader.close();
            this.currReader = null;
        }
    }

    public final void reset() throws IOException {
        this.close();
        this.seqFileIndex = 0;
        this.nextReader();
    }
}

