/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq;

import edu.msu.cme.rdp.readseq.QSequence;
import edu.msu.cme.rdp.readseq.readers.QSeqReader;
import edu.msu.cme.rdp.readseq.readers.SeqReader;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.SequenceReader;
import edu.msu.cme.rdp.readseq.readers.core.FastqCore;
import edu.msu.cme.rdp.readseq.writers.FastqWriter;
import java.io.File;
import java.io.IOException;

public class ToFastq {
    public static void main(String[] args) throws Exception {
        SeqReader reader;
        Object seq;
        if (args.length != 1 && args.length != 2) {
            System.err.println("USAGE: ToFastq <seqfile> [qualfile]");
            System.exit(1);
        }
        if (!((seq = (reader = args.length == 2 ? new QSeqReader(new File(args[0]), new File(args[1])) : new SequenceReader(new File(args[0]))).readNextSequence()) instanceof QSequence)) {
            throw new IOException("Input doesn't contain quality information");
        }
        FastqWriter out = new FastqWriter(System.out, FastqCore.Phred33QualFunction);
        long startTime = System.currentTimeMillis();
        int thisFileTotalSeqs = 0;
        do {
            out.writeSeq((Sequence)seq);
            ++thisFileTotalSeqs;
        } while ((seq = reader.readNextSequence()) != null);
        System.err.println("Converted " + thisFileTotalSeqs + " sequences (" + (Object)((Object)reader.getFormat()) + ") to fastq in " + (System.currentTimeMillis() - startTime) / 1000L + " s");
    }
}

