/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.train;

import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.utils.orientation.GoodWordIterator;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;

public class LineageSequence
extends Sequence {
    private List<String> ancestors;
    private static final String marker = "#";

    public LineageSequence(String n, List<String> al, String seq) {
        super(n, "", seq);
        this.ancestors = al;
        if (this.ancestors.isEmpty()) {
            throw new IllegalArgumentException("No lineage data for sequence " + n);
        }
    }

    public List<String> getAncestors() {
        return this.ancestors;
    }

    public String getDesc() {
        StringBuilder desc = new StringBuilder();
        desc.append(this.ancestors.get(0));
        for (int i = 1; i < this.ancestors.size(); ++i) {
            desc.append(";" + this.ancestors.get(i));
        }
        return desc.toString();
    }

    public GoodWordIterator getPartialSeqIteratorbyGoodBases(int num_good_bases) throws IOException {
        String partialSeq;
        int c;
        GoodWordIterator wordIterator = null;
        String sequence = super.getSeqString();
        int size = sequence.length();
        if (size < num_good_bases) {
            return wordIterator;
        }
        double d = Math.random();
        int loc = (int)Math.round((double)size * d);
        String newSeq = sequence.substring(loc, size) + marker + sequence.substring(0, loc);
        int numGoodBases = 0;
        StringReader in = new StringReader(newSeq);
        int offset = 0;
        while ((c = in.read()) != -1 && numGoodBases != num_good_bases) {
            int charIndex = GoodWordIterator.getCharIndex((int)c);
            numGoodBases = charIndex != -1 ? ++numGoodBases : 0;
            ++offset;
        }
        in.close();
        if (numGoodBases == num_good_bases && (wordIterator = new GoodWordIterator(partialSeq = newSeq.substring(offset - num_good_bases, offset))).getNumofWords() == 0) {
            wordIterator = null;
        }
        return wordIterator;
    }
}

