/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.converter.impl254;

import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.converter.impl254.AttributeConverter;
import psidev.psi.mi.xml.converter.impl254.CvTypeConverter;
import psidev.psi.mi.xml.converter.impl254.NamesConverter;
import psidev.psi.mi.xml.converter.impl254.OrganismConverter;
import psidev.psi.mi.xml.converter.impl254.XrefConverter;
import psidev.psi.mi.xml.dao.DAOFactory;
import psidev.psi.mi.xml.dao.PsiDAO;
import psidev.psi.mi.xml.model.InteractorType;
import psidev.psi.mi.xml254.jaxb.Attribute;
import psidev.psi.mi.xml254.jaxb.AttributeList;
import psidev.psi.mi.xml254.jaxb.Interactor;

public class InteractorConverter {
    private CvTypeConverter cvTypeConverter = new CvTypeConverter();
    private NamesConverter namesConverter = new NamesConverter();
    private XrefConverter xrefConverter = new XrefConverter();
    private OrganismConverter organismConverter = new OrganismConverter();
    private AttributeConverter attributeConverter = new AttributeConverter();
    private DAOFactory factory;

    public void setDAOFactory(DAOFactory factory) {
        this.factory = factory;
    }

    private void checkDependencies() throws ConverterException {
        if (this.factory == null) {
            throw new ConverterException("Please set a DAO factory in order to resolve experiment's id.");
        }
    }

    public psidev.psi.mi.xml.model.Interactor fromJaxb(Interactor jInteractor) throws ConverterException {
        String sequence;
        if (jInteractor == null) {
            throw new IllegalArgumentException("You must give a non null JAXB Interactor.");
        }
        this.checkDependencies();
        psidev.psi.mi.xml.model.Interactor mInteractor = new psidev.psi.mi.xml.model.Interactor();
        mInteractor.setId(jInteractor.getId());
        mInteractor.setInteractorType(this.cvTypeConverter.fromJaxb(jInteractor.getInteractorType(), InteractorType.class));
        if (jInteractor.getNames() != null) {
            mInteractor.setNames(this.namesConverter.fromJaxb(jInteractor.getNames()));
        }
        if (jInteractor.getXref() != null) {
            mInteractor.setXref(this.xrefConverter.fromJaxb(jInteractor.getXref()));
        }
        if (jInteractor.getOrganism() != null) {
            mInteractor.setOrganism(this.organismConverter.fromJaxb(jInteractor.getOrganism()));
        }
        if ((sequence = jInteractor.getSequence()) != null) {
            sequence = sequence.trim();
        }
        mInteractor.setSequence(sequence);
        if (jInteractor.getAttributeList() != null) {
            for (Attribute attribute : jInteractor.getAttributeList().getAttributes()) {
                mInteractor.getAttributes().add(this.attributeConverter.fromJaxb(attribute));
            }
        }
        PsiDAO<psidev.psi.mi.xml.model.Interactor> interactorDAO = this.factory.getInteractorDAO();
        interactorDAO.store(mInteractor);
        return mInteractor;
    }

    public Interactor toJaxb(psidev.psi.mi.xml.model.Interactor mInteractor) throws ConverterException {
        String sequence;
        if (mInteractor == null) {
            throw new IllegalArgumentException("You must give a non null model Interactor.");
        }
        this.checkDependencies();
        Interactor jInteractor = new Interactor();
        jInteractor.setId(mInteractor.getId());
        jInteractor.setInteractorType(this.cvTypeConverter.toJaxb(mInteractor.getInteractorType()));
        if (mInteractor.getNames() != null) {
            jInteractor.setNames(this.namesConverter.toJaxb(mInteractor.getNames()));
        }
        if (mInteractor.hasXref()) {
            jInteractor.setXref(this.xrefConverter.toJaxb(mInteractor.getXref()));
        }
        if (mInteractor.hasOrganism()) {
            jInteractor.setOrganism(this.organismConverter.toJaxb(mInteractor.getOrganism(), Interactor.Organism.class));
        }
        if ((sequence = mInteractor.getSequence()) != null) {
            sequence = sequence.trim();
        }
        jInteractor.setSequence(sequence);
        if (mInteractor.hasAttributes()) {
            jInteractor.setAttributeList(new AttributeList());
            for (psidev.psi.mi.xml.model.Attribute attribute : mInteractor.getAttributes()) {
                jInteractor.getAttributeList().getAttributes().add(this.attributeConverter.toJaxb(attribute));
            }
        }
        return jInteractor;
    }
}

