/*
 * Decompiled with CFR 0.152.
 */
package org.sbgn;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class ConvertMilestone1to2 {
    static Namespace M1 = Namespace.getNamespace("http://sbgn.org/libsbgn/pd/0.1");
    static Namespace M2 = Namespace.getNamespace("http://sbgn.org/libsbgn/0.2");
    Set<String> existingIds = new HashSet<String>();
    int nextId = 0;

    public static void convert(File in, File out) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(in);
        Element elt = doc.getRootElement();
        ConvertMilestone1to2.recursivelyChangeNamespace(elt);
        elt.getChild("map", M2).setAttribute("language", "process description");
        ConvertMilestone1to2 converter = new ConvertMilestone1to2();
        converter.buildIdList(elt);
        converter.addArcIds(elt);
        ConvertMilestone1to2.recursivelyChangeStoichiometry(elt);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (Writer)new FileWriter(out));
    }

    private void buildIdList(Element elt) {
        String id = elt.getAttributeValue("id");
        if (id != null) {
            this.existingIds.add(id);
        }
        for (Object o : elt.getChildren()) {
            this.buildIdList((Element)o);
        }
    }

    private String generateId(String prefix) {
        String val;
        do {
            val = prefix + String.format("%06x", this.nextId);
            ++this.nextId;
        } while (this.existingIds.contains(val));
        return val;
    }

    private void addArcIds(Element elt) {
        if ("arc".equals(elt.getName())) {
            if (elt.getAttributeValue("id") == null) {
                String newId = this.generateId("arc");
                this.existingIds.add(newId);
                elt.setAttribute("id", newId);
            }
        } else {
            for (Object o : elt.getChildren()) {
                this.addArcIds((Element)o);
            }
        }
    }

    private static void recursivelyChangeNamespace(Element elt) {
        elt.setNamespace(M2);
        for (Object o : elt.getChildren()) {
            ConvertMilestone1to2.recursivelyChangeNamespace((Element)o);
        }
    }

    private static void recursivelyChangeStoichiometry(Element elt) {
        if ("stoichiometry".equals(elt.getAttributeValue("class"))) {
            elt.setAttribute("class", "cardinality");
        }
        for (Object o : elt.getChildren()) {
            ConvertMilestone1to2.recursivelyChangeStoichiometry((Element)o);
        }
    }

    public static void main(String[] args) throws JDOMException, IOException {
        if (args.length != 2) {
            System.err.println("Expected two arguments: in-file and out-file.");
            System.exit(1);
        } else {
            File fin = new File(args[0]);
            File fout = new File(args[1]);
            ConvertMilestone1to2.convert(fin, fout);
        }
    }
}

