/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.miner;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.Pattern;
import org.biopax.paxtools.pattern.PatternBox;
import org.biopax.paxtools.pattern.miner.MinerAdapter;

public class ControlsStateChangeDetailedMiner
extends MinerAdapter {
    public ControlsStateChangeDetailedMiner() {
        super("controls-state-change-detailed", "Captures exactly the same pattern as \"Controls-state-change\", but the result file is more detailed. Together with upstream and downstream genes, it also contains modifications of the upstream entity, as well as the gained and lost modifications of the downstream entity.");
    }

    @Override
    public Pattern constructPattern() {
        return PatternBox.controlsStateChange();
    }

    @Override
    public void writeResult(Map<BioPAXElement, List<Match>> matches2, OutputStream out) throws IOException {
        this.writeResultDetailed(matches2, out, 5);
    }

    @Override
    public String getHeader() {
        return "Upstream\tModifications-of-upstream\tDownstream\tGain-of-downstream\tLoss-of-downstream";
    }

    @Override
    public String getValue(Match m, int col) {
        switch (col) {
            case 0: {
                return this.getGeneSymbol(m, "controller ER");
            }
            case 1: {
                return this.concat(this.getModifications(m, "controller simple PE", "controller PE"), " ");
            }
            case 2: {
                return this.getGeneSymbol(m, "changed ER");
            }
            case 3: {
                return this.concat(this.getDeltaModifications(m, "input simple PE", "input PE", "output simple PE", "output PE")[0], " ");
            }
            case 4: {
                return this.concat(this.getDeltaModifications(m, "input simple PE", "input PE", "output simple PE", "output PE")[1], " ");
            }
        }
        throw new RuntimeException("Invalid col number: " + col);
    }
}

