/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinTable;
import javax.persistence.Transient;
import org.biopax.paxtools.impl.level3.XReferrableImpl;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.util.BPCollections;
import org.biopax.paxtools.util.SetStringBridge;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Boost;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;

@Entity
@Proxy(proxyClass=Named.class)
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public abstract class NamedImpl
extends XReferrableImpl
implements Named {
    private String standardName = null;
    private String displayName = null;
    private Set<String> allNames = BPCollections.I.createSet();

    @Field(name="name", analyze=Analyze.YES, boost=@Boost(value=3.0f))
    @Column(columnDefinition="LONGTEXT")
    protected String getStandardNameX() {
        return this.standardName;
    }

    protected void setStandardNameX(String name) {
        this.standardName = name;
    }

    @Override
    @Transient
    public String getStandardName() {
        return this.standardName;
    }

    @Override
    public void setStandardName(String name) {
        this.standardName = name;
        this.addName(this.standardName);
    }

    @Field(name="name", analyze=Analyze.YES, boost=@Boost(value=2.5f))
    @Column(columnDefinition="LONGTEXT")
    protected String getDisplayNameX() {
        return this.displayName;
    }

    protected void setDisplayNameX(String displayName) {
        this.displayName = displayName;
    }

    @Override
    @Transient
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        this.addName(this.displayName);
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ElementCollection(fetch=FetchType.EAGER)
    @JoinTable(name="name")
    @Field(name="name", analyze=Analyze.YES, boost=@Boost(value=2.5f), bridge=@FieldBridge(impl=SetStringBridge.class))
    @Column(columnDefinition="LONGTEXT")
    public Set<String> getName() {
        return this.allNames;
    }

    @Override
    public void setName(Set<String> names) {
        this.allNames = names;
        if (this.displayName != null && !this.displayName.isEmpty()) {
            this.allNames.add(this.displayName);
        }
        if (this.standardName != null && !this.standardName.isEmpty()) {
            this.allNames.add(this.standardName);
        }
    }

    @Override
    public void addName(String name) {
        if (name != null && name.length() > 0) {
            this.allNames.add(name);
        }
    }

    @Override
    public void removeName(String name) {
        if (name != null) {
            this.allNames.remove(name);
            if (name.equals(this.standardName)) {
                this.standardName = null;
            }
            if (name.equals(this.displayName)) {
                this.displayName = null;
            }
        }
    }
}

