/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.biopax.paxtools.impl.level3.ConversionImpl;
import org.biopax.paxtools.impl.level3.DeltaGImpl;
import org.biopax.paxtools.impl.level3.KPrimeImpl;
import org.biopax.paxtools.model.level3.BiochemicalReaction;
import org.biopax.paxtools.model.level3.DeltaG;
import org.biopax.paxtools.model.level3.KPrime;
import org.biopax.paxtools.util.BPCollections;
import org.biopax.paxtools.util.SetStringBridge;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;

@Entity
@Proxy(proxyClass=BiochemicalReaction.class)
@Indexed
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class BiochemicalReactionImpl
extends ConversionImpl
implements BiochemicalReaction {
    private Set<Float> deltaS;
    private Set<KPrime> kEQ;
    private Set<Float> deltaH;
    private Set<DeltaG> deltaG = BPCollections.I.createSafeSet();
    private Set<String> eCNumber;

    public BiochemicalReactionImpl() {
        this.deltaH = BPCollections.I.createSet();
        this.deltaS = BPCollections.I.createSet();
        this.eCNumber = BPCollections.I.createSet();
        this.kEQ = BPCollections.I.createSafeSet();
    }

    @Transient
    public Class<? extends BiochemicalReaction> getModelInterface() {
        return BiochemicalReaction.class;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @OneToMany(targetEntity=DeltaGImpl.class)
    @JoinTable(name="deltaG")
    public Set<DeltaG> getDeltaG() {
        return this.deltaG;
    }

    protected void setDeltaG(Set<DeltaG> deltaG) {
        this.deltaG = deltaG;
    }

    @Override
    public void addDeltaG(DeltaG deltaG) {
        if (deltaG != null) {
            this.deltaG.add(deltaG);
        }
    }

    @Override
    public void removeDeltaG(DeltaG deltaG) {
        if (deltaG != null) {
            this.deltaG.remove(deltaG);
        }
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ElementCollection
    @JoinTable(name="deltaH")
    public Set<Float> getDeltaH() {
        return this.deltaH;
    }

    protected void setDeltaH(Set<Float> deltaH) {
        this.deltaH = deltaH;
    }

    @Override
    public void addDeltaH(float deltaH) {
        this.deltaH.add(Float.valueOf(deltaH));
    }

    @Override
    public void removeDeltaH(float deltaH) {
        this.deltaH.remove(Float.valueOf(deltaH));
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ElementCollection
    @JoinTable(name="deltaS")
    public Set<Float> getDeltaS() {
        return this.deltaS;
    }

    protected void setDeltaS(Set<Float> deltaS) {
        this.deltaS = deltaS;
    }

    @Override
    public void addDeltaS(float deltaS) {
        this.deltaS.add(Float.valueOf(deltaS));
    }

    @Override
    public void removeDeltaS(float deltaS) {
        this.deltaS.remove(new Float(deltaS));
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ElementCollection
    @JoinTable(name="ECNumber")
    @Field(name="ecnumber", analyze=Analyze.YES)
    @FieldBridge(impl=SetStringBridge.class)
    public Set<String> getECNumber() {
        return this.eCNumber;
    }

    protected void setECNumber(Set<String> eCNumber) {
        this.eCNumber = eCNumber;
    }

    @Override
    public void addECNumber(String eCNumber) {
        this.eCNumber.add(eCNumber);
    }

    @Override
    public void removeECNumber(String eCNumber) {
        this.eCNumber.remove(eCNumber);
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @OneToMany(targetEntity=KPrimeImpl.class)
    @JoinTable(name="keq")
    public Set<KPrime> getKEQ() {
        return this.kEQ;
    }

    protected void setKEQ(Set<KPrime> kEQ) {
        this.kEQ = kEQ;
    }

    @Override
    public void addKEQ(KPrime kEQ) {
        this.kEQ.add(kEQ);
    }

    @Override
    public void removeKEQ(KPrime kEQ) {
        this.kEQ.remove(kEQ);
    }
}

