/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.AbstractPropertyEditor;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.Traverser;
import org.biopax.paxtools.controller.Visitor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.util.Filter;

public class Cloner
implements Visitor {
    private static final Log LOG = LogFactory.getLog(Cloner.class);
    Traverser traverser;
    private BioPAXFactory factory;
    private Model targetModel;

    public Cloner(EditorMap map, BioPAXFactory factory) {
        this.factory = factory;
        this.traverser = new Traverser(map, this, new Filter[0]);
        this.targetModel = null;
    }

    public Model clone(Model source, Set<BioPAXElement> toBeCloned) {
        this.targetModel = this.factory.createModel();
        for (BioPAXElement bpe : new HashSet<BioPAXElement>(toBeCloned)) {
            if (this.targetModel.containsID(bpe.getRDFId())) {
                throw new RuntimeException("There are same URI different objects in the input set, uri:" + bpe.getRDFId());
            }
            this.targetModel.addNew(bpe.getModelInterface(), bpe.getRDFId());
        }
        AbstractPropertyEditor.checkRestrictions.set(false);
        for (BioPAXElement bpe : toBeCloned) {
            this.traverser.traverse(bpe, source);
        }
        AbstractPropertyEditor.checkRestrictions.set(true);
        return this.targetModel;
    }

    public void visit(BioPAXElement domain, Object range, Model model, PropertyEditor editor) {
        BioPAXElement targetDomain = this.targetModel.getByID(domain.getRDFId());
        if (range instanceof BioPAXElement) {
            BioPAXElement bpe = (BioPAXElement)range;
            BioPAXElement existing = this.targetModel.getByID(bpe.getRDFId());
            if (existing != null) {
                editor.setValueToBean(existing, targetDomain);
            }
        } else {
            editor.setValueToBean(range, targetDomain);
        }
    }
}

