/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.sort.FixedSortKeyDefinition;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.StringValue;

public class SortKeyDefinition
implements Serializable {
    private static StringValue defaultOrder = new StringValue("ascending");
    private static StringValue defaultCaseOrder = new StringValue("#default");
    private static StringValue defaultLanguage = StringValue.EMPTY_STRING;
    protected Expression sortKey;
    protected Expression order = defaultOrder;
    protected Expression dataTypeExpression = EmptySequence.getInstance();
    protected Expression caseOrder = defaultCaseOrder;
    protected Expression language = defaultLanguage;
    protected Expression collationName = null;
    protected Comparator collation;
    protected String baseURI;
    protected boolean emptyLeast = true;
    protected Container parentExpression;

    public void setParentExpression(Container container2) {
        this.parentExpression = container2;
    }

    public Container getParentExpression() {
        return this.parentExpression;
    }

    public void setSortKey(Expression expression) {
        this.sortKey = expression;
    }

    public Expression getSortKey() {
        return this.sortKey;
    }

    public void setOrder(Expression expression) {
        this.order = expression;
    }

    public Expression getOrder() {
        return this.order;
    }

    public void setDataTypeExpression(Expression expression) {
        this.dataTypeExpression = expression;
    }

    public Expression getDataTypeExpression() {
        return this.dataTypeExpression;
    }

    public void setCaseOrder(Expression expression) {
        this.caseOrder = expression;
    }

    public Expression getCaseOrder() {
        return this.caseOrder;
    }

    public void setLanguage(Expression expression) {
        this.language = expression;
    }

    public Expression getLanguage() {
        return this.language;
    }

    public void setCollationName(Expression expression) {
        this.collationName = expression;
    }

    public Expression getCollationName() {
        return this.collationName;
    }

    public void setCollation(Comparator comparator) {
        this.collation = comparator;
    }

    public Comparator getCollation() {
        return this.collation;
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setEmptyLeast(boolean bl) {
        this.emptyLeast = bl;
    }

    public boolean getEmptyLeast() {
        return this.emptyLeast;
    }

    public SortKeyDefinition simplify(StaticContext staticContext, Executable executable) throws XPathException {
        if (this.order instanceof StringValue && (this.dataTypeExpression == null || this.dataTypeExpression instanceof StringValue) && this.caseOrder instanceof StringValue && this.language instanceof StringValue && this.collation != null) {
            FixedSortKeyDefinition fixedSortKeyDefinition = new FixedSortKeyDefinition();
            fixedSortKeyDefinition.setParentExpression(this.parentExpression);
            fixedSortKeyDefinition.setSortKey(this.sortKey);
            fixedSortKeyDefinition.setOrder(this.order);
            fixedSortKeyDefinition.setDataTypeExpression(this.dataTypeExpression);
            fixedSortKeyDefinition.setCaseOrder(this.caseOrder);
            fixedSortKeyDefinition.setLanguage(this.language);
            fixedSortKeyDefinition.setEmptyLeast(this.emptyLeast);
            fixedSortKeyDefinition.collation = this.collation;
            fixedSortKeyDefinition.baseURI = this.baseURI;
            fixedSortKeyDefinition.bindComparer(staticContext.makeEarlyEvaluationContext());
            return fixedSortKeyDefinition;
        }
        return this;
    }

    public FixedSortKeyDefinition reduce(XPathContext xPathContext) throws XPathException {
        FixedSortKeyDefinition fixedSortKeyDefinition = new FixedSortKeyDefinition();
        Expression expression = this.sortKey;
        fixedSortKeyDefinition.setSortKey(expression);
        fixedSortKeyDefinition.setOrder((StringValue)this.order.evaluateItem(xPathContext));
        fixedSortKeyDefinition.setDataTypeExpression((StringValue)this.dataTypeExpression.evaluateItem(xPathContext));
        fixedSortKeyDefinition.setCaseOrder((StringValue)this.caseOrder.evaluateItem(xPathContext));
        fixedSortKeyDefinition.setLanguage((StringValue)this.language.evaluateItem(xPathContext));
        if (this.collation == null && this.collationName != null) {
            Object object;
            URI uRI;
            String string = this.collationName.evaluateItem(xPathContext).getStringValue();
            try {
                uRI = new URI(string);
                if (!uRI.isAbsolute()) {
                    if (this.baseURI == null) {
                        throw new DynamicError("Collation URI is relative, and base URI is unknown");
                    }
                    object = new URI(this.baseURI);
                    uRI = ((URI)object).resolve(uRI);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new DynamicError("Collation name " + string + " is not a valid URI: " + uRISyntaxException);
            }
            object = xPathContext.getCollation(uRI.toString());
            if (object == null) {
                throw new DynamicError("Collation " + uRI + " is not recognized");
            }
            fixedSortKeyDefinition.setCollation((Comparator)object);
        }
        if (this.collation != null) {
            fixedSortKeyDefinition.setCollation(this.collation);
        }
        fixedSortKeyDefinition.setEmptyLeast(this.emptyLeast);
        fixedSortKeyDefinition.bindComparer(xPathContext);
        return fixedSortKeyDefinition;
    }
}

