/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.NumericPromoter;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UntypedAtomicConverter;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.functions.StringFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public final class TypeChecker {
    private TypeChecker() {
    }

    public static Expression staticTypeCheck(Expression object, SequenceType sequenceType, boolean bl, RoleLocator roleLocator, StaticContext staticContext) throws StaticError {
        Object object2;
        int n;
        boolean bl2;
        boolean bl3;
        Object object3 = object;
        TypeHierarchy typeHierarchy = staticContext.getNamePool().getTypeHierarchy();
        ItemType itemType = sequenceType.getPrimaryType();
        int n2 = sequenceType.getCardinality();
        boolean bl4 = Cardinality.allowsMany(n2);
        ItemType itemType2 = null;
        int n4 = -1;
        boolean bl5 = bl3 = n2 == 57344;
        if (!bl3) {
            n4 = object3.getCardinality();
            bl3 = Cardinality.subsumes(n2, n4);
        }
        if (!(bl2 = itemType instanceof AnyItemType)) {
            itemType2 = object3.getItemType(typeHierarchy);
            if (itemType2 instanceof NoNodeTest) {
                bl2 = true;
            } else {
                n = typeHierarchy.relationship(itemType, itemType2);
                boolean bl6 = bl2 = n == 0 || n == 1;
            }
        }
        if (bl && !bl4) {
            if (Cardinality.allowsMany(n4)) {
                FirstItemExpression firstItemExpression = new FirstItemExpression((Expression)object3);
                firstItemExpression.adoptChildExpression((Expression)object3);
                object3 = firstItemExpression;
                n4 = 24576;
                bl3 = Cardinality.subsumes(n2, n4);
            }
            if (!bl2) {
                if (itemType == Type.STRING_TYPE) {
                    StringFn stringFn = (StringFn)SystemFunction.makeSystemFunction("string", 1, staticContext.getNamePool());
                    stringFn.setParentExpression(object3.getParentExpression());
                    object2 = new Expression[]{object3};
                    stringFn.setArguments((Expression[])object2);
                    try {
                        object3 = stringFn.simplify(staticContext).typeCheck(staticContext, AnyItemType.getInstance());
                    }
                    catch (XPathException xPathException) {
                        throw xPathException.makeStatic();
                    }
                    itemType2 = Type.STRING_TYPE;
                    n4 = 16384;
                    bl3 = Cardinality.subsumes(n2, n4);
                    bl2 = true;
                }
                if (itemType == Type.NUMBER_TYPE || itemType == Type.DOUBLE_TYPE) {
                    NumberFn numberFn = (NumberFn)SystemFunction.makeSystemFunction("number", 1, staticContext.getNamePool());
                    object2 = new Expression[]{object3};
                    numberFn.setArguments((Expression[])object2);
                    try {
                        object3 = numberFn.simplify(staticContext).typeCheck(staticContext, AnyItemType.getInstance());
                    }
                    catch (XPathException xPathException) {
                        throw xPathException.makeStatic();
                    }
                    itemType2 = Type.DOUBLE_TYPE;
                    n4 = 16384;
                    bl3 = Cardinality.subsumes(n2, n4);
                    bl2 = true;
                }
            }
        }
        if (!bl2 && itemType instanceof AtomicType) {
            if (!(itemType2 instanceof AtomicType) && n4 != 8192) {
                Atomizer atomizer = new Atomizer((Expression)object3, staticContext.getConfiguration());
                object3 = atomizer;
                itemType2 = object3.getItemType(typeHierarchy);
                n4 = object3.getCardinality();
                bl3 = Cardinality.subsumes(n2, n4);
            }
            if (itemType2 == Type.UNTYPED_ATOMIC_TYPE && itemType != Type.UNTYPED_ATOMIC_TYPE && itemType != Type.ANY_ATOMIC_TYPE) {
                UntypedAtomicConverter untypedAtomicConverter = new UntypedAtomicConverter((Expression)object3, (AtomicType)itemType, true);
                try {
                    object3 = object3 instanceof Value ? new SequenceExtent(((ComputedExpression)untypedAtomicConverter).iterate(staticContext.makeEarlyEvaluationContext())).simplify() : untypedAtomicConverter;
                }
                catch (XPathException xPathException) {
                    throw xPathException.makeStatic();
                }
                bl2 = true;
                itemType2 = itemType;
            }
            if (itemType2 == Type.ANY_ATOMIC_TYPE && itemType != Type.UNTYPED_ATOMIC_TYPE && itemType != Type.ANY_ATOMIC_TYPE) {
                UntypedAtomicConverter untypedAtomicConverter = new UntypedAtomicConverter((Expression)object3, (AtomicType)itemType, false);
                try {
                    object3 = object3 instanceof Value ? new SequenceExtent(((ComputedExpression)untypedAtomicConverter).iterate(staticContext.makeEarlyEvaluationContext())).simplify() : untypedAtomicConverter;
                }
                catch (XPathException xPathException) {
                    throw xPathException.makeStatic();
                }
            }
            if (((n = ((AtomicType)itemType).getFingerprint()) == 517 || n == 516) && typeHierarchy.relationship(itemType2, Type.NUMBER_TYPE) != 4) {
                object3 = new NumericPromoter((Expression)object3, n);
                try {
                    object3 = object3.simplify(staticContext).typeCheck(staticContext, AnyItemType.getInstance());
                }
                catch (XPathException xPathException) {
                    throw xPathException.makeStatic();
                }
                itemType2 = n == 517 ? Type.DOUBLE_TYPE : Type.FLOAT_TYPE;
                n4 = -1;
            }
            if (n == 513 && typeHierarchy.isSubType(itemType2, Type.ANY_URI_TYPE)) {
                itemType2 = Type.STRING_TYPE;
                bl2 = true;
            }
        }
        if (bl2 && bl3) {
            return object3;
        }
        if (n4 == -1) {
            n4 = object3.getCardinality();
            if (!bl3) {
                bl3 = Cardinality.subsumes(n2, n4);
            }
        }
        if (bl3 && n4 == 8192) {
            return object3;
        }
        if (n4 == 8192 && (n2 & 0x2000) == 0) {
            StaticError staticError = new StaticError("An empty sequence is not allowed as the " + roleLocator.getMessage(), TypeChecker.getLocator((Expression)object, roleLocator));
            staticError.setErrorCode(roleLocator.getErrorCode());
            staticError.setIsTypeError(true);
            throw staticError;
        }
        int n5 = n = bl2 ? 2 : typeHierarchy.relationship(itemType2, itemType);
        if (n == 4) {
            if (Cardinality.allowsZero(n4) && Cardinality.allowsZero(n2)) {
                if (n4 != 8192) {
                    object2 = "Required item type of " + roleLocator.getMessage() + " is " + itemType.toString(staticContext.getNamePool()) + "; supplied value has item type " + itemType2.toString(staticContext.getNamePool()) + ". The expression can succeed only if the supplied value is an empty sequence.";
                    staticContext.issueWarning((String)object2, TypeChecker.getLocator((Expression)object, roleLocator));
                }
            } else {
                object2 = new StaticError("Required item type of " + roleLocator.getMessage() + " is " + itemType.toString(staticContext.getNamePool()) + "; supplied value has item type " + itemType2.toString(staticContext.getNamePool()), TypeChecker.getLocator((Expression)object, roleLocator));
                ((XPathException)object2).setErrorCode(roleLocator.getErrorCode());
                ((XPathException)object2).setIsTypeError(true);
                throw object2;
            }
        }
        if (n != 0 && n != 2) {
            if (object3 instanceof Value) {
                object2 = new StaticError("Required item type of " + roleLocator.getMessage() + " is " + itemType.toString(staticContext.getNamePool()) + "; supplied value has item type " + itemType2.toString(staticContext.getNamePool()), TypeChecker.getLocator((Expression)object, roleLocator));
                ((XPathException)object2).setErrorCode(roleLocator.getErrorCode());
                ((XPathException)object2).setIsTypeError(true);
                throw object2;
            }
            object2 = new ItemChecker((Expression)object3, itemType, roleLocator);
            ((ComputedExpression)object2).adoptChildExpression((Expression)object3);
            object3 = object2;
        }
        if (!bl3) {
            if (object3 instanceof Value) {
                object2 = new StaticError("Required cardinality of " + roleLocator.getMessage() + " is " + Cardinality.toString(n2) + "; supplied value has cardinality " + Cardinality.toString(n4), TypeChecker.getLocator((Expression)object, roleLocator));
                ((XPathException)object2).setIsTypeError(true);
                ((XPathException)object2).setErrorCode(roleLocator.getErrorCode());
                throw object2;
            }
            object2 = CardinalityChecker.makeCardinalityChecker((Expression)object3, n2, roleLocator);
            ((ComputedExpression)object2).adoptChildExpression((Expression)object3);
            object3 = object2;
        }
        return object3;
    }

    public static Expression strictTypeCheck(Expression expression, SequenceType sequenceType, RoleLocator roleLocator, StaticContext staticContext) throws StaticError {
        Object object;
        int n;
        boolean bl;
        boolean bl2;
        Expression expression2 = expression;
        TypeHierarchy typeHierarchy = staticContext.getNamePool().getTypeHierarchy();
        ItemType itemType = sequenceType.getPrimaryType();
        int n2 = sequenceType.getCardinality();
        ItemType itemType2 = null;
        int n4 = -1;
        boolean bl3 = bl2 = n2 == 57344;
        if (!bl2) {
            n4 = expression2.getCardinality();
            bl2 = Cardinality.subsumes(n2, n4);
        }
        if (!(bl = sequenceType.getPrimaryType() instanceof AnyItemType)) {
            itemType2 = expression2.getItemType(typeHierarchy);
            n = typeHierarchy.relationship(itemType, itemType2);
            boolean bl4 = bl = n == 0 || n == 1;
        }
        if (bl && bl2) {
            return expression2;
        }
        if (n4 == -1) {
            n4 = itemType2 instanceof NoNodeTest ? 8192 : expression2.getCardinality();
            if (!bl2) {
                bl2 = Cardinality.subsumes(n2, n4);
            }
        }
        if (bl2 && n4 == 8192) {
            return expression2;
        }
        if (itemType2 == null) {
            itemType2 = expression2.getItemType(typeHierarchy);
        }
        if (n4 == 8192 && (n2 & 0x2000) == 0) {
            StaticError staticError = new StaticError("An empty sequence is not allowed as the " + roleLocator.getMessage(), TypeChecker.getLocator(expression, roleLocator));
            staticError.setErrorCode(roleLocator.getErrorCode());
            staticError.setIsTypeError(true);
            throw staticError;
        }
        n = typeHierarchy.relationship(itemType2, itemType);
        if (n == 4) {
            if (Cardinality.allowsZero(n4) && Cardinality.allowsZero(n2)) {
                if (n4 != 8192) {
                    object = "Required item type of " + roleLocator.getMessage() + " is " + itemType.toString(staticContext.getNamePool()) + "; supplied value has item type " + itemType2.toString(staticContext.getNamePool()) + ". The expression can succeed only if the supplied value is an empty sequence.";
                    staticContext.issueWarning((String)object, TypeChecker.getLocator(expression, roleLocator));
                }
            } else {
                StaticError staticError = new StaticError("Required item type of " + roleLocator.getMessage() + " is " + itemType.toString(staticContext.getNamePool()) + "; supplied value has item type " + itemType2.toString(staticContext.getNamePool()), TypeChecker.getLocator(expression, roleLocator));
                staticError.setErrorCode(roleLocator.getErrorCode());
                staticError.setIsTypeError(true);
                throw staticError;
            }
        }
        if (n != 0 && n != 2) {
            object = new ItemChecker(expression2, itemType, roleLocator);
            ((ComputedExpression)object).adoptChildExpression(expression2);
            expression2 = object;
        }
        if (!bl2) {
            if (expression2 instanceof Value) {
                object = new StaticError("Required cardinality of " + roleLocator.getMessage() + " is " + Cardinality.toString(n2) + "; supplied value has cardinality " + Cardinality.toString(n4), TypeChecker.getLocator(expression, roleLocator));
                ((XPathException)object).setIsTypeError(true);
                ((XPathException)object).setErrorCode(roleLocator.getErrorCode());
                throw object;
            }
            object = CardinalityChecker.makeCardinalityChecker(expression2, n2, roleLocator);
            ((ComputedExpression)object).adoptChildExpression(expression2);
            expression2 = object;
        }
        return expression2;
    }

    private static SourceLocator getLocator(Expression expression, RoleLocator roleLocator) {
        SourceLocator sourceLocator = ExpressionTool.getLocator(expression);
        if (sourceLocator == null) {
            sourceLocator = roleLocator.getSourceLocator();
        }
        return sourceLocator;
    }

    public static DynamicError testConformance(Value value, SequenceType sequenceType, Configuration configuration) {
        ItemType itemType = sequenceType.getPrimaryType();
        TypeHierarchy typeHierarchy = configuration.getNamePool().getTypeHierarchy();
        if (!typeHierarchy.isSubType(value.getItemType(typeHierarchy), itemType)) {
            DynamicError dynamicError = new DynamicError("Global parameter requires type " + itemType + "; supplied value has type " + value.getItemType(typeHierarchy));
            dynamicError.setIsTypeError(true);
            return dynamicError;
        }
        int n = sequenceType.getCardinality();
        if (!Cardinality.subsumes(n, value.getCardinality())) {
            DynamicError dynamicError = new DynamicError("Supplied value of external parameter does not match the required cardinality");
            dynamicError.setIsTypeError(true);
            return dynamicError;
        }
        return null;
    }

    public static XPathException ebvError(Expression expression, TypeHierarchy typeHierarchy) {
        if (Cardinality.allowsZero(expression.getCardinality())) {
            return null;
        }
        ItemType itemType = expression.getItemType(typeHierarchy);
        if (typeHierarchy.relationship(itemType, Type.NODE_TYPE) == 4 && typeHierarchy.relationship(itemType, Type.BOOLEAN_TYPE) == 4 && typeHierarchy.relationship(itemType, Type.STRING_TYPE) == 4 && typeHierarchy.relationship(itemType, Type.ANY_URI_TYPE) == 4 && typeHierarchy.relationship(itemType, Type.UNTYPED_ATOMIC_TYPE) == 4 && typeHierarchy.relationship(itemType, Type.NUMBER_TYPE) == 4 && typeHierarchy.relationship(itemType, ExternalObjectType.GENERAL_EXTERNAL_OBJECT_TYPE) == 4) {
            DynamicError dynamicError = new DynamicError("Effective boolean value is defined only for sequences containing booleans, strings, numbers, URIs, or nodes");
            dynamicError.setErrorCode("FORG0006");
            dynamicError.setIsTypeError(true);
            return dynamicError;
        }
        return null;
    }
}

