/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class TracingFilter
extends ProxyReceiver {
    private static int id = 0;
    private String indent = "";

    public TracingFilter() {
        ++id;
    }

    public TracingFilter(Receiver receiver) {
        ++id;
        this.setUnderlyingReceiver(receiver);
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n4, int n5) throws XPathException {
        System.err.println("RCVR " + id + this.indent + " ATTRIBUTE " + this.getNamePool().getDisplayName(n));
        super.attribute(n, n2, charSequence, n4, n5);
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        System.err.println("RCVR " + id + this.indent + " CHARACTERS " + (Whitespace.isWhite(charSequence) ? "(whitespace)" : ""));
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length() * 3);
        for (int i = 0; i < charSequence.length(); ++i) {
            fastStringBuffer.append(charSequence.charAt(i) + " ");
        }
        System.err.println("    \"" + fastStringBuffer + '\"');
        super.characters(charSequence, n, n2);
    }

    public void close() throws XPathException {
        System.err.println("RCVR " + id + this.indent + " CLOSE");
        super.close();
    }

    public void comment(CharSequence charSequence, int n, int n2) throws XPathException {
        System.err.println("RCVR " + id + this.indent + " COMMENT");
        super.comment(charSequence, n, n2);
    }

    public void endDocument() throws XPathException {
        System.err.println("RCVR " + id + this.indent + " END DOCUMENT");
        super.endDocument();
    }

    public void endElement() throws XPathException {
        this.indent = this.indent.substring(2);
        System.err.println("RCVR " + id + this.indent + " END ELEMENT");
        super.endElement();
    }

    public void namespace(int n, int n2) throws XPathException {
        System.err.println("RCVR " + id + this.indent + " NAMESPACE " + this.getNamePool().getPrefixFromNamespaceCode(n) + "=" + this.getNamePool().getURIFromNamespaceCode(n));
        super.namespace(n, n2);
    }

    public void open() throws XPathException {
        System.err.println("RCVR " + id + this.indent + " OPEN");
        super.open();
    }

    public void processingInstruction(String string, CharSequence charSequence, int n, int n2) throws XPathException {
        System.err.println("RCVR " + id + this.indent + " PROCESSING INSTRUCTION");
        super.processingInstruction(string, charSequence, n, n2);
    }

    public void startContent() throws XPathException {
        System.err.println("RCVR " + id + this.indent + " START CONTENT");
        super.startContent();
    }

    public void startDocument(int n) throws XPathException {
        System.err.println("RCVR " + id + this.indent + " START DOCUMENT");
        new NullPointerException("debug").printStackTrace();
        super.startDocument(n);
    }

    public void startElement(int n, int n2, int n4, int n5) throws XPathException {
        System.err.println("RCVR " + id + this.indent + " START ELEMENT " + this.getNamePool().getDisplayName(n));
        this.indent = this.indent + "  ";
        super.startElement(n, n2, n4, n5);
    }
}

