/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.modify.GraphStoreBasic;
import com.hp.hpl.jena.sparql.modify.UpdateProcessorFactory;
import com.hp.hpl.jena.sparql.modify.UpdateProcessorVisitor;
import com.hp.hpl.jena.sparql.modify.op.Update;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateProcessor;
import com.hp.hpl.jena.update.UpdateRequest;
import java.util.Iterator;

public class UpdateProcessorMain
implements UpdateProcessor {
    private GraphStore graphStore;
    private UpdateRequest request;
    private Binding inputBinding;

    private UpdateProcessorMain(GraphStore graphStore, UpdateRequest request, Binding inputBinding) {
        this.graphStore = graphStore;
        this.request = request;
        this.inputBinding = inputBinding;
    }

    public void execute() {
        this.graphStore.startRequest();
        UpdateProcessorVisitor v = new UpdateProcessorVisitor(this.graphStore, this.inputBinding);
        Iterator iter = this.request.getUpdates().iterator();
        while (iter.hasNext()) {
            Update update = (Update)iter.next();
            update.visit(v);
        }
        this.graphStore.finishRequest();
    }

    public static UpdateProcessorFactory getFactory() {
        return new UpdateProcessorFactory(){

            public boolean accept(UpdateRequest request, GraphStore graphStore) {
                return graphStore instanceof GraphStoreBasic;
            }

            public UpdateProcessor create(UpdateRequest request, GraphStore graphStore, Binding inputBinding) {
                return new UpdateProcessorMain(graphStore, request, inputBinding);
            }
        };
    }
}

