/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.opt;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVars;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.util.VarUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class TransformFilterPlacement
extends TransformCopy {
    static boolean doFilterPlacement = true;

    public static Op transform(ExprList exprs, BasicPattern bgp) {
        if (!doFilterPlacement) {
            return OpFilter.filter(exprs, (Op)new OpBGP(bgp));
        }
        return TransformFilterPlacement.transformFilterBGP(exprs, new HashSet(), bgp);
    }

    public Op transform(OpFilter opFilter, Op x) {
        HashSet varsScope;
        if (!doFilterPlacement) {
            return super.transform(opFilter, x);
        }
        ExprList exprs = new ExprList(opFilter.getExprs());
        Op op = TransformFilterPlacement.transform(exprs, varsScope = new HashSet(), x);
        if (op == x) {
            return super.transform(opFilter, x);
        }
        op = TransformFilterPlacement.buildFilter(exprs, op);
        return op;
    }

    private static Op transform(ExprList exprs, Set varsScope, Op x) {
        if (x instanceof OpBGP) {
            return TransformFilterPlacement.transformFilterBGP(exprs, varsScope, (OpBGP)x);
        }
        if (x instanceof OpSequence) {
            return TransformFilterPlacement.transformFilterSequence(exprs, varsScope, (OpSequence)x);
        }
        OpVars.patternVars(x, varsScope);
        return x;
    }

    private static Op transformFilterBGP(ExprList exprs, Set patternVarsScope, OpBGP x) {
        return TransformFilterPlacement.transformFilterBGP(exprs, patternVarsScope, x.getPattern());
    }

    private static Op transformFilterBGP(ExprList exprs, Set patternVarsScope, BasicPattern pattern) {
        Op op = TransformFilterPlacement.insertAnyFilter(exprs, patternVarsScope, null);
        ListIterator iter = pattern.getList().listIterator();
        while (iter.hasNext()) {
            Triple triple = (Triple)iter.next();
            OpBGP opBGP = TransformFilterPlacement.getBGP(op);
            if (opBGP == null) {
                opBGP = new OpBGP();
                op = OpSequence.create(op, opBGP);
            }
            opBGP.getPattern().add(triple);
            VarUtils.addVarsFromTriple(patternVarsScope, triple);
            op = TransformFilterPlacement.insertAnyFilter(exprs, patternVarsScope, op);
        }
        return op;
    }

    private static Op transformFilterSequence(ExprList exprs, Set varScope, OpSequence opSequence) {
        List ops = opSequence.getElements();
        Op op = TransformFilterPlacement.insertAnyFilter(exprs, varScope, null);
        Iterator iter = ops.iterator();
        while (iter.hasNext()) {
            Op seqElt = (Op)iter.next();
            seqElt = TransformFilterPlacement.transform(exprs, varScope, seqElt);
            op = OpSequence.create(op, seqElt);
            op = TransformFilterPlacement.insertAnyFilter(exprs, varScope, op);
        }
        return op;
    }

    private static Op insertAnyFilter(ExprList exprs, Set patternVarsScope, Op op) {
        Iterator iter = exprs.iterator();
        while (iter.hasNext()) {
            Expr expr = (Expr)iter.next();
            Set exprVars = expr.getVarsMentioned();
            if (!patternVarsScope.containsAll(exprVars)) continue;
            if (op == null) {
                op = OpTable.unit();
            }
            op = OpFilter.filter(expr, op);
            iter.remove();
        }
        return op;
    }

    private static OpBGP getBGP(Op op) {
        Op opTop;
        OpSequence opSeq;
        List x;
        if (op instanceof OpBGP) {
            return (OpBGP)op;
        }
        if (op instanceof OpSequence && (x = (opSeq = (OpSequence)op).getElements()).size() > 0 && (opTop = (Op)x.get(x.size() - 1)) instanceof OpBGP) {
            return (OpBGP)opTop;
        }
        return null;
    }

    private static Op buildFilter(ExprList exprs, Op op) {
        if (exprs.isEmpty()) {
            return op;
        }
        Iterator iter = exprs.iterator();
        while (iter.hasNext()) {
            Expr expr = (Expr)iter.next();
            if (op == null) {
                op = OpTable.unit();
            }
            op = OpFilter.filter(expr, op);
            iter.remove();
        }
        return op;
    }
}

