/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.ExpressionSet;
import com.hp.hpl.jena.graph.query.NamedGraphMap;
import com.hp.hpl.jena.graph.query.NamedTripleBunches;
import com.hp.hpl.jena.graph.query.Rewrite;
import com.hp.hpl.jena.graph.query.SimpleQueryEngine;
import com.hp.hpl.jena.graph.query.TripleSorter;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.List;

public class Query {
    public static final Node ANY = Node.ANY;
    public static final Node S = Node.createVariable("S");
    public static final Node P = Node.createVariable("P");
    public static final Node O = Node.createVariable("O");
    public static final Node X = Node.createVariable("X");
    public static final Node Y = Node.createVariable("Y");
    public static final Node Z = Node.createVariable("Z");
    private NamedTripleBunches triples = new NamedTripleBunches();
    private List triplePattern = new ArrayList();
    private ExpressionSet constraint = new ExpressionSet();
    private SimpleQueryEngine lastQueryEngine = null;
    private NamedGraphMap argMap = new NamedGraphMap();
    public static final TripleSorter dontSort = TripleSorter.dontSort;
    private TripleSorter sortMethod = TripleSorter.dontSort;

    public Query() {
    }

    public Query(Graph pattern) {
        this.addMatches(pattern);
    }

    public Query addMatch(Node s, Node p, Node o) {
        return this.addNamedMatch("<this>", s, p, o);
    }

    public Query addMatch(String name, Node s, Node p, Node o) {
        return this.addNamedMatch(name, s, p, o);
    }

    public Query addMatch(Triple t) {
        this.triplePattern.add(t);
        this.triples.add("<this>", t);
        return this;
    }

    private Query addNamedMatch(String name, Node s, Node p, Node o) {
        this.triplePattern.add(Triple.create(s, p, o));
        this.triples.add(name, Triple.create(s, p, o));
        return this;
    }

    public List getPattern() {
        return new ArrayList(this.triplePattern);
    }

    public ExpressionSet getConstraints() {
        return this.constraint;
    }

    public Query addConstraint(Expression e2) {
        if (e2.isApply() && e2.getFun().equals("urn:x-jena:expr:AND")) {
            for (int i = 0; i < e2.argCount(); ++i) {
                this.addConstraint(e2.getArg(i));
            }
        } else if (e2.isApply() && e2.argCount() == 2 && e2.getFun().equals("urn:x-jena:expr:Q_StringMatch")) {
            this.constraint.add(Rewrite.rewriteStringMatch(e2));
        } else {
            this.constraint.add(e2);
        }
        return this;
    }

    private void addMatches(Graph p) {
        ExtendedIterator it = GraphUtil.findAll(p);
        while (it.hasNext()) {
            this.addMatch((Triple)it.next());
        }
    }

    public ExtendedIterator executeBindings(Graph g, Node[] results) {
        return this.executeBindings(this.args().put("<this>", g), results);
    }

    public ExtendedIterator executeBindings(Graph g, List stages, Node[] results) {
        return this.executeBindings(stages, this.args().put("<this>", g), results);
    }

    public ExtendedIterator executeBindings(NamedGraphMap args, Node[] nodes) {
        return this.executeBindings(new ArrayList(), args, nodes);
    }

    public ExtendedIterator executeBindings(List outStages, NamedGraphMap args, Node[] nodes) {
        SimpleQueryEngine e2 = new SimpleQueryEngine(this.triples, this.sortMethod, this.constraint);
        ExtendedIterator result = e2.executeBindings(outStages, args, nodes);
        this.lastQueryEngine = e2;
        return result;
    }

    public NamedTripleBunches getTriples() {
        return this.triples;
    }

    public NamedGraphMap args() {
        return this.argMap;
    }

    public TripleSorter getSorter() {
        return this.sortMethod;
    }

    public void setTripleSorter(TripleSorter ts) {
        this.sortMethod = ts == null ? TripleSorter.dontSort : ts;
    }

    public int getVariableCount() {
        return this.lastQueryEngine.getVariableCount();
    }

    public static class UnboundVariableException
    extends JenaException {
        public UnboundVariableException(Node n) {
            super(n.toString());
        }
    }
}

