/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

public class Hex {
    private static final char[] int2hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Hex() {
    }

    public static String toString(byte by) {
        StringBuilder stringBuilder = new StringBuilder(2);
        stringBuilder.append(int2hex[by >> 4 & 0xF]);
        stringBuilder.append(int2hex[by & 0xF]);
        return stringBuilder.toString();
    }

    public static String toString(char c) {
        StringBuilder stringBuilder = new StringBuilder(4);
        stringBuilder.append(int2hex[c >> 12 & 0xF]);
        stringBuilder.append(int2hex[c >> 8 & 0xF]);
        stringBuilder.append(int2hex[c >> 4 & 0xF]);
        stringBuilder.append(int2hex[c & 0xF]);
        return stringBuilder.toString();
    }

    public static String toString(short s) {
        StringBuilder stringBuilder = new StringBuilder(4);
        stringBuilder.append(int2hex[s >> 12 & 0xF]);
        stringBuilder.append(int2hex[s >> 8 & 0xF]);
        stringBuilder.append(int2hex[s >> 4 & 0xF]);
        stringBuilder.append(int2hex[s & 0xF]);
        return stringBuilder.toString();
    }

    public static String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder(8);
        stringBuilder.append(int2hex[n >> 28 & 0xF]);
        stringBuilder.append(int2hex[n >> 24 & 0xF]);
        stringBuilder.append(int2hex[n >> 20 & 0xF]);
        stringBuilder.append(int2hex[n >> 16 & 0xF]);
        stringBuilder.append(int2hex[n >> 12 & 0xF]);
        stringBuilder.append(int2hex[n >> 8 & 0xF]);
        stringBuilder.append(int2hex[n >> 4 & 0xF]);
        stringBuilder.append(int2hex[n & 0xF]);
        return stringBuilder.toString();
    }

    public static String toString(long l) {
        StringBuilder stringBuilder = new StringBuilder(16);
        stringBuilder.append(int2hex[(int)(l >> 60) & 0xF]);
        stringBuilder.append(int2hex[(int)(l >> 56) & 0xF]);
        stringBuilder.append(int2hex[(int)(l >> 52) & 0xF]);
        stringBuilder.append(int2hex[(int)(l >> 48) & 0xF]);
        stringBuilder.append(int2hex[(int)(l >> 44) & 0xF]);
        stringBuilder.append(int2hex[(int)(l >> 40) & 0xF]);
        stringBuilder.append(int2hex[(int)(l >> 36) & 0xF]);
        stringBuilder.append(int2hex[(int)(l >> 32) & 0xF]);
        stringBuilder.append(int2hex[(int)(l >> 28) & 0xF]);
        stringBuilder.append(int2hex[(int)(l >> 24) & 0xF]);
        stringBuilder.append(int2hex[(int)(l >> 20) & 0xF]);
        stringBuilder.append(int2hex[(int)(l >> 16) & 0xF]);
        stringBuilder.append(int2hex[(int)(l >> 12) & 0xF]);
        stringBuilder.append(int2hex[(int)(l >> 8) & 0xF]);
        stringBuilder.append(int2hex[(int)(l >> 4) & 0xF]);
        stringBuilder.append(int2hex[(int)l & 0xF]);
        return stringBuilder.toString();
    }

    public static String toString(byte[] byArray) {
        return Hex.toString(byArray, 0, byArray.length);
    }

    public static String toString(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        StringBuilder stringBuilder = new StringBuilder(2 * n2);
        while (n2 > 0) {
            stringBuilder.append(int2hex[byArray[n] >> 4 & 0xF]);
            stringBuilder.append(int2hex[byArray[n] & 0xF]);
            ++n;
            --n2;
        }
        return stringBuilder.toString();
    }

    public static byte toByte(String string) {
        return (byte)Hex.toInt(string);
    }

    public static char toChar(String string) {
        return (char)Hex.toInt(string);
    }

    public static short toShort(String string) {
        return (short)Hex.toInt(string);
    }

    public static int toInt(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            n = (n << 4) + Hex.hex2int(string.charAt(i));
        }
        return n;
    }

    public static long toLong(String string) {
        long l = 0L;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            l = (l << 4) + (long)Hex.hex2int(string.charAt(i));
        }
        return l;
    }

    public static byte[] toByteArray(String string) {
        int n = (string.length() + 1) / 2;
        byte[] byArray = new byte[n];
        Hex.toByteArray(string, byArray, 0, byArray.length);
        return byArray;
    }

    public static void toByteArray(String string, byte[] byArray) {
        Hex.toByteArray(string, byArray, 0, byArray.length);
    }

    public static void toByteArray(String string, byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = string.length() - 1;
        int n4 = n + n2 - 1;
        while (n2 > 0 && n3 >= 0) {
            int n5 = Hex.hex2int(string.charAt(n3));
            if (--n3 >= 0) {
                n5 += Hex.hex2int(string.charAt(n3)) << 4;
            }
            --n3;
            byArray[n4] = (byte)n5;
            --n4;
            --n2;
        }
        while (n2 > 0) {
            byArray[n4] = 0;
            --n4;
            --n2;
        }
    }

    private static int hex2int(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return c - 48;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return c - 97 + 10;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return c - 65 + 10;
            }
        }
        throw new IllegalArgumentException("Not a hexadecimal digit: '" + c + "'");
    }
}

