/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.smp.network;

import edu.rit.io.DoubleMatrixFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class FloydSeq {
    static int n;
    static double[][] d;

    private FloydSeq() {
    }

    public static void main(String[] stringArray) throws Throwable {
        long l = System.currentTimeMillis();
        if (stringArray.length != 2) {
            FloydSeq.usage();
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        DoubleMatrixFile doubleMatrixFile = new DoubleMatrixFile();
        DoubleMatrixFile.Reader reader = doubleMatrixFile.prepareToRead(new BufferedInputStream(new FileInputStream(file)));
        reader.read();
        reader.close();
        n = doubleMatrixFile.getRowCount();
        d = doubleMatrixFile.getMatrix();
        long l2 = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            double[] dArray = d[i];
            for (int j = 0; j < n; ++j) {
                double[] dArray2 = d[j];
                for (int k = 0; k < n; ++k) {
                    dArray2[k] = Math.min(dArray2[k], dArray2[i] + dArray[k]);
                }
            }
        }
        long l3 = System.currentTimeMillis();
        DoubleMatrixFile.Writer writer = doubleMatrixFile.prepareToWrite(new BufferedOutputStream(new FileOutputStream(file2)));
        writer.write();
        writer.close();
        long l4 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec pre");
        System.out.println(l3 - l2 + " msec calc");
        System.out.println(l4 - l3 + " msec post");
        System.out.println(l4 - l + " msec total");
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.smp.network.FloydSeq <infile> <outfile>");
        System.err.println("<infile> = Input distance matrix file");
        System.err.println("<outfile> = Output distance matrix file");
        System.exit(1);
    }
}

