/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.replica;

import edu.rit.mp.FloatBuf;
import edu.rit.mp.buf.FloatItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.reduction.FloatOp;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class ReplicatedFloat
extends Number {
    private FloatOp myOp;
    private AtomicInteger myValue;
    private int myTag;
    private Comm myComm;
    private Receiver myReceiver;

    public ReplicatedFloat(FloatOp floatOp) {
        this(floatOp, 0.0f, 0, Comm.world());
    }

    public ReplicatedFloat(FloatOp floatOp, float f) {
        this(floatOp, f, 0, Comm.world());
    }

    public ReplicatedFloat(FloatOp floatOp, float f, int n) {
        this(floatOp, f, n, Comm.world());
    }

    public ReplicatedFloat(FloatOp floatOp, float f, int n, Comm comm) {
        if (floatOp == null) {
            throw new NullPointerException("ReplicatedFloat(): op is null");
        }
        if (comm == null) {
            throw new NullPointerException("ReplicatedFloat(): comm is null");
        }
        this.myOp = floatOp;
        this.myValue = new AtomicInteger(Float.floatToIntBits(f));
        this.myTag = n;
        this.myComm = comm;
        this.myReceiver = new Receiver();
        this.myReceiver.setDaemon(true);
        this.myReceiver.start();
    }

    public float get() {
        return Float.intBitsToFloat(this.myValue.get());
    }

    public float reduce(float f) throws IOException {
        float f2;
        float f3;
        int n;
        int n2;
        while (!this.myValue.compareAndSet(n2 = this.myValue.get(), n = Float.floatToIntBits(f3 = this.myOp.op(f2 = Float.intBitsToFloat(n2), f)))) {
        }
        if (f3 != f2) {
            this.myComm.floodSend(this.myTag, FloatBuf.buffer(f3));
        }
        return f3;
    }

    public String toString() {
        return Float.toString(this.get());
    }

    public int intValue() {
        return (int)this.get();
    }

    public long longValue() {
        return (long)this.get();
    }

    public float floatValue() {
        return this.get();
    }

    public double doubleValue() {
        return this.get();
    }

    private class Receiver
    extends Thread {
        private Receiver() {
        }

        public void run() {
            FloatItemBuf floatItemBuf = FloatBuf.buffer();
            try {
                while (true) {
                    int n;
                    int n2;
                    ReplicatedFloat.this.myComm.floodReceive(ReplicatedFloat.this.myTag, floatItemBuf);
                    do {
                        n2 = ReplicatedFloat.this.myValue.get();
                        float f = Float.intBitsToFloat(n2);
                        float f2 = ReplicatedFloat.this.myOp.op(f, floatItemBuf.item);
                        n = Float.floatToIntBits(f2);
                    } while (!ReplicatedFloat.this.myValue.compareAndSet(n2, n));
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
                return;
            }
        }
    }
}

