/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.ShortOp;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class SharedShortArray {
    private AtomicIntegerArray myArray;

    public SharedShortArray(int n) {
        this.myArray = new AtomicIntegerArray(n);
    }

    public SharedShortArray(short[] sArray) {
        int n = sArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = sArray[i];
        }
        this.myArray = new AtomicIntegerArray(nArray);
    }

    public int length() {
        return this.myArray.length();
    }

    public short get(int n) {
        return (short)this.myArray.get(n);
    }

    public void set(int n, short s) {
        this.myArray.set(n, s);
    }

    public short getAndSet(int n, short s) {
        return (short)this.myArray.getAndSet(n, s);
    }

    public boolean compareAndSet(int n, short s, short s2) {
        return this.myArray.compareAndSet(n, s, s2);
    }

    public boolean weakCompareAndSet(int n, short s, short s2) {
        return this.myArray.weakCompareAndSet(n, s, s2);
    }

    public short getAndIncrement(int n) {
        short s;
        short s2;
        while (!this.myArray.compareAndSet(n, s2 = (short)this.myArray.get(n), s = (short)(s2 + 1))) {
        }
        return s2;
    }

    public short getAndDecrement(int n) {
        short s;
        short s2;
        while (!this.myArray.compareAndSet(n, s2 = (short)this.myArray.get(n), s = (short)(s2 - 1))) {
        }
        return s2;
    }

    public short getAndAdd(int n, short s) {
        short s2;
        short s3;
        while (!this.myArray.compareAndSet(n, s3 = (short)this.myArray.get(n), s2 = (short)(s3 + s))) {
        }
        return s3;
    }

    public short incrementAndGet(int n) {
        short s;
        short s2;
        while (!this.myArray.compareAndSet(n, s2 = (short)this.myArray.get(n), s = (short)(s2 + 1))) {
        }
        return s;
    }

    public short decrementAndGet(int n) {
        short s;
        short s2;
        while (!this.myArray.compareAndSet(n, s2 = (short)this.myArray.get(n), s = (short)(s2 - 1))) {
        }
        return s;
    }

    public short addAndGet(int n, short s) {
        short s2;
        short s3;
        while (!this.myArray.compareAndSet(n, s3 = (short)this.myArray.get(n), s2 = (short)(s3 + s))) {
        }
        return s2;
    }

    public short reduce(int n, short s, ShortOp shortOp) {
        short s2;
        short s3;
        while (!this.myArray.compareAndSet(n, s3 = (short)this.myArray.get(n), s2 = shortOp.op(s3, s))) {
        }
        return s2;
    }

    public void reduce(short[] sArray, ShortOp shortOp) {
        this.reduce(0, sArray, 0, this.myArray.length(), shortOp);
    }

    public void reduce(int n, short[] sArray, int n2, int n3, ShortOp shortOp) {
        if (n3 < 0 || n < 0 || n + n3 > this.myArray.length() || n2 < 0 || n2 + n3 > sArray.length) {
            throw new IndexOutOfBoundsException();
        }
        while (n3 > 0) {
            short s;
            short s2;
            while (!this.myArray.compareAndSet(n, s2 = (short)this.myArray.get(n), s = shortOp.op(s2, sArray[n2]))) {
            }
            ++n;
            ++n2;
            --n3;
        }
    }

    public String toString() {
        return this.myArray.toString();
    }
}

