/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.FloatOp;
import java.util.concurrent.atomic.AtomicInteger;

public class SharedFloat
extends Number {
    private AtomicInteger myValue;

    public SharedFloat() {
        this.myValue = new AtomicInteger(Float.floatToIntBits(0.0f));
    }

    public SharedFloat(float f) {
        this.myValue = new AtomicInteger(Float.floatToIntBits(f));
    }

    public float get() {
        return Float.intBitsToFloat(this.myValue.get());
    }

    public void set(float f) {
        this.myValue.set(Float.floatToIntBits(f));
    }

    public float getAndSet(float f) {
        return Float.intBitsToFloat(this.myValue.getAndSet(Float.floatToIntBits(f)));
    }

    public boolean compareAndSet(float f, float f2) {
        return this.myValue.compareAndSet(Float.floatToIntBits(f), Float.floatToIntBits(f2));
    }

    public boolean weakCompareAndSet(float f, float f2) {
        return this.myValue.weakCompareAndSet(Float.floatToIntBits(f), Float.floatToIntBits(f2));
    }

    public float getAndIncrement() {
        float f;
        float f2;
        int n;
        int n2;
        while (!this.myValue.compareAndSet(n2 = this.myValue.get(), n = Float.floatToIntBits(f2 = (f = Float.intBitsToFloat(n2)) + 1.0f))) {
        }
        return f;
    }

    public float getAndDecrement() {
        float f;
        float f2;
        int n;
        int n2;
        while (!this.myValue.compareAndSet(n2 = this.myValue.get(), n = Float.floatToIntBits(f2 = (f = Float.intBitsToFloat(n2)) - 1.0f))) {
        }
        return f;
    }

    public float getAndAdd(float f) {
        float f2;
        float f3;
        int n;
        int n2;
        while (!this.myValue.compareAndSet(n2 = this.myValue.get(), n = Float.floatToIntBits(f3 = (f2 = Float.intBitsToFloat(n2)) + f))) {
        }
        return f2;
    }

    public float incrementAndGet() {
        float f;
        float f2;
        int n;
        int n2;
        while (!this.myValue.compareAndSet(n2 = this.myValue.get(), n = Float.floatToIntBits(f2 = (f = Float.intBitsToFloat(n2)) + 1.0f))) {
        }
        return f2;
    }

    public float decrementAndGet() {
        float f;
        float f2;
        int n;
        int n2;
        while (!this.myValue.compareAndSet(n2 = this.myValue.get(), n = Float.floatToIntBits(f2 = (f = Float.intBitsToFloat(n2)) - 1.0f))) {
        }
        return f2;
    }

    public float addAndGet(float f) {
        float f2;
        float f3;
        int n;
        int n2;
        while (!this.myValue.compareAndSet(n2 = this.myValue.get(), n = Float.floatToIntBits(f3 = (f2 = Float.intBitsToFloat(n2)) + f))) {
        }
        return f3;
    }

    public float reduce(float f, FloatOp floatOp) {
        float f2;
        float f3;
        int n;
        int n2;
        while (!this.myValue.compareAndSet(n2 = this.myValue.get(), n = Float.floatToIntBits(f3 = floatOp.op(f2 = Float.intBitsToFloat(n2), f)))) {
        }
        return f3;
    }

    public String toString() {
        return Float.toString(this.get());
    }

    public int intValue() {
        return (int)this.get();
    }

    public long longValue() {
        return (long)this.get();
    }

    public float floatValue() {
        return this.get();
    }

    public double doubleValue() {
        return this.get();
    }
}

