/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.ByteOp;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class SharedByteArray {
    private AtomicIntegerArray myArray;

    public SharedByteArray(int n) {
        this.myArray = new AtomicIntegerArray(n);
    }

    public SharedByteArray(byte[] byArray) {
        int n = byArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = byArray[i];
        }
        this.myArray = new AtomicIntegerArray(nArray);
    }

    public int length() {
        return this.myArray.length();
    }

    public byte get(int n) {
        return (byte)this.myArray.get(n);
    }

    public void set(int n, byte by) {
        this.myArray.set(n, by);
    }

    public byte getAndSet(int n, byte by) {
        return (byte)this.myArray.getAndSet(n, by);
    }

    public boolean compareAndSet(int n, byte by, byte by2) {
        return this.myArray.compareAndSet(n, by, by2);
    }

    public boolean weakCompareAndSet(int n, byte by, byte by2) {
        return this.myArray.weakCompareAndSet(n, by, by2);
    }

    public byte getAndIncrement(int n) {
        byte by;
        byte by2;
        while (!this.myArray.compareAndSet(n, by2 = (byte)this.myArray.get(n), by = (byte)(by2 + 1))) {
        }
        return by2;
    }

    public byte getAndDecrement(int n) {
        byte by;
        byte by2;
        while (!this.myArray.compareAndSet(n, by2 = (byte)this.myArray.get(n), by = (byte)(by2 - 1))) {
        }
        return by2;
    }

    public byte getAndAdd(int n, byte by) {
        byte by2;
        byte by3;
        while (!this.myArray.compareAndSet(n, by3 = (byte)this.myArray.get(n), by2 = (byte)(by3 + by))) {
        }
        return by3;
    }

    public byte incrementAndGet(int n) {
        byte by;
        byte by2;
        while (!this.myArray.compareAndSet(n, by2 = (byte)this.myArray.get(n), by = (byte)(by2 + 1))) {
        }
        return by;
    }

    public byte decrementAndGet(int n) {
        byte by;
        byte by2;
        while (!this.myArray.compareAndSet(n, by2 = (byte)this.myArray.get(n), by = (byte)(by2 - 1))) {
        }
        return by;
    }

    public byte addAndGet(int n, byte by) {
        byte by2;
        byte by3;
        while (!this.myArray.compareAndSet(n, by3 = (byte)this.myArray.get(n), by2 = (byte)(by3 + by))) {
        }
        return by2;
    }

    public byte reduce(int n, byte by, ByteOp byteOp) {
        byte by2;
        byte by3;
        while (!this.myArray.compareAndSet(n, by3 = (byte)this.myArray.get(n), by2 = byteOp.op(by3, by))) {
        }
        return by2;
    }

    public void reduce(byte[] byArray, ByteOp byteOp) {
        this.reduce(0, byArray, 0, this.myArray.length(), byteOp);
    }

    public void reduce(int n, byte[] byArray, int n2, int n3, ByteOp byteOp) {
        if (n3 < 0 || n < 0 || n + n3 > this.myArray.length() || n2 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        while (n3 > 0) {
            byte by;
            byte by2;
            while (!this.myArray.compareAndSet(n, by2 = (byte)this.myArray.get(n), by = byteOp.op(by2, byArray[n2]))) {
            }
            ++n;
            ++n2;
            --n3;
        }
    }

    public String toString() {
        return this.myArray.toString();
    }
}

