/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.http.HttpRequest;
import edu.rit.http.HttpResponse;
import edu.rit.http.HttpServer;
import edu.rit.mp.Channel;
import edu.rit.mp.ChannelGroup;
import edu.rit.mp.ChannelGroupClosedException;
import edu.rit.mp.ConnectListener;
import edu.rit.mp.ObjectBuf;
import edu.rit.mp.Status;
import edu.rit.mp.buf.ObjectItemBuf;
import edu.rit.pj.cluster.BackendInfo;
import edu.rit.pj.cluster.Configuration;
import edu.rit.pj.cluster.JobFrontendProxy;
import edu.rit.pj.cluster.JobFrontendRef;
import edu.rit.pj.cluster.JobInfo;
import edu.rit.pj.cluster.JobSchedulerMessage;
import edu.rit.pj.cluster.JobSchedulerRef;
import edu.rit.util.Logger;
import edu.rit.util.PrintStreamLogger;
import edu.rit.util.Timer;
import edu.rit.util.TimerTask;
import edu.rit.util.TimerThread;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JobScheduler
implements JobSchedulerRef {
    private String myClusterName;
    private Logger myLog;
    private String myWebHost;
    private int myWebPort;
    private String mySchedulerHost;
    private int mySchedulerPort;
    private String myFrontendHost;
    private int myJobTime;
    private Map<String, BackendInfo> myNameToBackendMap = new HashMap<String, BackendInfo>();
    private BackendInfo[] myBackendInfo;
    private int myBackendCount;
    private int myNextBackendNumber = 0;
    private int myNextJobNumber = 1;
    private Map<JobFrontendRef, JobInfo> myFrontendToJobMap = new HashMap<JobFrontendRef, JobInfo>();
    private List<JobInfo> myRunningJobList = new LinkedList<JobInfo>();
    private List<JobInfo> myWaitingJobList = new LinkedList<JobInfo>();
    private TimerThread myLeaseTimerThread;
    private ChannelGroup myChannelGroup;
    private HttpServer myHttpServer;
    private long myTotalComputeTime;
    private long myStartDateTime;

    private JobScheduler(String string) throws IOException {
        long l;
        this.myStartDateTime = l = System.currentTimeMillis();
        Configuration configuration = new Configuration(string);
        this.myClusterName = configuration.getClusterName();
        this.myLog = new PrintStreamLogger(new PrintStream(new FileOutputStream(configuration.getLogFile(), true), true));
        this.myWebHost = configuration.getWebHost();
        this.myWebPort = configuration.getWebPort();
        this.mySchedulerHost = configuration.getSchedulerHost();
        this.mySchedulerPort = configuration.getSchedulerPort();
        this.myFrontendHost = configuration.getFrontendHost();
        this.myJobTime = configuration.getJobTime();
        this.myBackendCount = configuration.getBackendCount();
        this.myBackendInfo = new BackendInfo[this.myBackendCount];
        for (int i = 0; i < this.myBackendCount; ++i) {
            BackendInfo backendInfo = configuration.getBackendInfo(i);
            this.myNameToBackendMap.put(backendInfo.name, backendInfo);
            this.myBackendInfo[i] = backendInfo;
        }
        this.myLog.log(l, "Started Parallel Java v20120620");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                JobScheduler.this.shutdown();
            }
        });
        this.myLeaseTimerThread = new TimerThread();
        this.myLeaseTimerThread.setDaemon(true);
        this.myLeaseTimerThread.start();
        this.myChannelGroup = new ChannelGroup(new InetSocketAddress(this.mySchedulerHost, this.mySchedulerPort), this.myLog);
        this.myLog.log(l, "Job Scheduler at " + this.myChannelGroup.listenAddress());
        this.myChannelGroup.setConnectListener(new ConnectListener(){

            public void nearEndConnected(ChannelGroup channelGroup, Channel channel) {
            }

            public void farEndConnected(ChannelGroup channelGroup, Channel channel) {
                JobScheduler.this.createJob(channel);
            }
        });
        this.myHttpServer = new HttpServer(new InetSocketAddress(this.myWebHost, this.myWebPort), this.myLog){

            protected void process(HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
                JobScheduler.this.processHttpRequest(httpRequest, httpResponse);
            }
        };
        this.myLog.log(l, "Web interface at " + this.myHttpServer.getAddress());
        for (BackendInfo backendInfo : this.myBackendInfo) {
            this.myLog.log(l, "Backend " + backendInfo.name + " at " + backendInfo.host + ", " + backendInfo.totalCpus + " CPU" + (backendInfo.totalCpus == 1 ? "" : "s"));
        }
        this.myChannelGroup.startListening();
    }

    private synchronized void createJob(Channel channel) {
        JobFrontendProxy jobFrontendProxy = new JobFrontendProxy(this.myChannelGroup, channel);
        channel.info(jobFrontendProxy);
        JobInfo jobInfo = this.getJobInfo(jobFrontendProxy);
        jobInfo.renewTimer.start(60000L, 60000L);
        jobInfo.expireTimer.start(150000L);
    }

    private void run() {
        ObjectItemBuf<JobSchedulerMessage> objectItemBuf = ObjectBuf.buffer((JobSchedulerMessage)null);
        Status status = null;
        JobSchedulerMessage jobSchedulerMessage = null;
        JobFrontendRef jobFrontendRef = null;
        while (true) {
            try {
                status = this.myChannelGroup.receive(null, null, objectItemBuf);
            }
            catch (ChannelGroupClosedException channelGroupClosedException) {
                break;
            }
            catch (Throwable throwable) {
                this.myLog.log("Exception while receiving message", throwable);
                break;
            }
            jobSchedulerMessage = (JobSchedulerMessage)objectItemBuf.item;
            jobFrontendRef = (JobFrontendRef)status.channel.info();
            try {
                jobSchedulerMessage.invoke(this, jobFrontendRef);
            }
            catch (Throwable throwable) {
                this.myLog.log("Exception while processing message", throwable);
            }
            objectItemBuf.item = null;
            status = null;
            jobSchedulerMessage = null;
            jobFrontendRef = null;
        }
    }

    public synchronized void backendFailed(JobFrontendRef jobFrontendRef, String string) throws IOException {
        BackendInfo backendInfo = this.myNameToBackendMap.get(string);
        if (backendInfo != null) {
            long l = System.currentTimeMillis();
            this.myLog.log(l, "Backend " + string + " failed");
        }
    }

    public synchronized void cancelJob(JobFrontendRef jobFrontendRef, String string) throws IOException {
        JobInfo jobInfo = this.getJobInfo(jobFrontendRef);
        this.doCancelJob(System.currentTimeMillis(), jobInfo, string);
    }

    public synchronized void jobFinished(JobFrontendRef jobFrontendRef) throws IOException {
        JobInfo jobInfo = this.getJobInfo(jobFrontendRef);
        this.doFinishJob(System.currentTimeMillis(), jobInfo);
    }

    public synchronized void renewLease(JobFrontendRef jobFrontendRef) throws IOException {
        JobInfo jobInfo = this.getJobInfo(jobFrontendRef);
        jobInfo.expireTimer.start(150000L);
    }

    public synchronized void reportComment(JobFrontendRef jobFrontendRef, int n, String string) {
        JobInfo jobInfo = this.getJobInfo(jobFrontendRef);
        jobInfo.comment[n] = string;
    }

    public synchronized void requestJob(JobFrontendRef jobFrontendRef, String string, int n, int n2, int n3) throws IOException {
        JobInfo jobInfo = this.getJobInfo(jobFrontendRef);
        long l = System.currentTimeMillis();
        this.myLog.log(l, "Job " + jobInfo.jobnum + " queued, username=" + string + ", nn=" + n + ", np=" + n2 + ", nt=" + n3);
        jobInfo.username = string;
        jobInfo.Nn = Math.min(n, n2);
        jobInfo.Np = n2;
        jobInfo.Nt = n3;
        jobInfo.backend = new BackendInfo[n2];
        jobInfo.cpus = new int[n2];
        jobInfo.comment = new String[n2];
        for (int i = 0; i < n2; ++i) {
            jobInfo.comment[i] = "";
        }
        if (!this.enoughResourcesForJob(jobInfo.Nn, jobInfo.Np, jobInfo.Nt)) {
            this.doCancelJobTooFewResources(l, jobInfo);
            return;
        }
        this.myWaitingJobList.add(jobInfo);
        jobFrontendRef.assignJobNumber(this, jobInfo.jobnum, this.myFrontendHost);
        this.assignResourcesToJobs(l);
    }

    public void close() {
    }

    private synchronized void renewTimeout(Timer timer, JobFrontendRef jobFrontendRef) throws IOException {
        if (timer.isTriggered()) {
            jobFrontendRef.renewLease(this);
        }
    }

    private synchronized void expireTimeout(Timer timer, JobFrontendRef jobFrontendRef) throws IOException {
        if (timer.isTriggered()) {
            JobInfo jobInfo = this.getJobInfo(jobFrontendRef);
            this.doCancelJob(System.currentTimeMillis(), jobInfo, "Job frontend lease expired");
        }
    }

    private synchronized void jobTimeout(Timer timer, JobFrontendRef jobFrontendRef) throws IOException {
        if (timer.isTriggered()) {
            JobInfo jobInfo = this.getJobInfo(jobFrontendRef);
            String string = "Maximum job time (" + this.myJobTime + " seconds) exceeded";
            jobInfo.frontend.cancelJob(this, string);
            this.doCancelJob(System.currentTimeMillis(), jobInfo, string);
        }
    }

    private JobInfo getJobInfo(JobFrontendRef jobFrontendRef) {
        final JobFrontendRef jobFrontendRef2 = jobFrontendRef;
        JobInfo jobInfo = this.myFrontendToJobMap.get(jobFrontendRef);
        if (jobInfo == null) {
            jobInfo = new JobInfo(this.myNextJobNumber++, JobInfo.State.WAITING, System.currentTimeMillis(), null, 0, 0, 0, 0, null, null, 0, jobFrontendRef2, this.myLeaseTimerThread.createTimer(new TimerTask(){

                public void action(Timer timer) {
                    try {
                        JobScheduler.this.renewTimeout(timer, jobFrontendRef2);
                    }
                    catch (Throwable throwable) {
                        JobScheduler.this.myLog.log(throwable);
                    }
                }
            }), this.myLeaseTimerThread.createTimer(new TimerTask(){

                public void action(Timer timer) {
                    try {
                        JobScheduler.this.expireTimeout(timer, jobFrontendRef2);
                    }
                    catch (Throwable throwable) {
                        JobScheduler.this.myLog.log(throwable);
                    }
                }
            }), this.myLeaseTimerThread.createTimer(new TimerTask(){

                public void action(Timer timer) {
                    try {
                        JobScheduler.this.jobTimeout(timer, jobFrontendRef2);
                    }
                    catch (Throwable throwable) {
                        JobScheduler.this.myLog.log(throwable);
                    }
                }
            }));
            this.myFrontendToJobMap.put(jobFrontendRef, jobInfo);
        }
        return jobInfo;
    }

    private void doFinishJob(long l, JobInfo jobInfo) throws IOException {
        this.myLog.log(l, "Job " + jobInfo.jobnum + " finished");
        this.doCleanupJob(l, jobInfo);
    }

    private void doCancelJob(long l, JobInfo jobInfo, String string) throws IOException {
        this.myLog.log(l, "Job " + jobInfo.jobnum + " canceled: " + string);
        this.doCleanupJob(l, jobInfo);
    }

    private void doCancelJobTooFewResources(long l, JobInfo jobInfo) throws IOException {
        String string = jobInfo.Nt == 0 ? "Too few resources available to assign " + jobInfo.Nn + " node" + (jobInfo.Nn == 1 ? "" : "s") + " and " + jobInfo.Np + " process" + (jobInfo.Np == 1 ? "" : "es") : "Too few resources available to assign " + jobInfo.Nn + " node" + (jobInfo.Nn == 1 ? "" : "s") + ", " + jobInfo.Np + " process" + (jobInfo.Np == 1 ? "" : "es") + ", and " + jobInfo.Nt + " CPU" + (jobInfo.Nt == 1 ? "" : "s") + " per process";
        jobInfo.frontend.cancelJob(this, string);
        this.doCancelJob(l, jobInfo, string);
    }

    private void doCleanupJob(long l, JobInfo jobInfo) throws IOException {
        jobInfo.renewTimer.stop();
        jobInfo.expireTimer.stop();
        jobInfo.jobTimer.stop();
        jobInfo.frontend.close();
        this.myFrontendToJobMap.remove(jobInfo.frontend);
        this.myRunningJobList.remove(jobInfo);
        this.myWaitingJobList.remove(jobInfo);
        for (int i = 0; i < jobInfo.count; ++i) {
            BackendInfo backendInfo = jobInfo.backend[i];
            if (backendInfo.state == BackendInfo.State.FAILED) continue;
            backendInfo.state = BackendInfo.State.IDLE;
            backendInfo.stateTime = l;
            backendInfo.job = null;
        }
        this.myTotalComputeTime += l - jobInfo.stateTime;
        this.assignResourcesToJobs(l);
    }

    private void assignResourcesToJobs(long l) throws IOException {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Iterator<JobInfo> iterator = this.myWaitingJobList.iterator();
        while (iterator.hasNext()) {
            JobInfo jobInfo = iterator.next();
            if (!this.enoughResourcesForJob(jobInfo.Nn, jobInfo.Np, jobInfo.Nt)) {
                iterator.remove();
                linkedList.add(jobInfo);
                continue;
            }
            int n = jobInfo.Np / jobInfo.Nn;
            int n2 = jobInfo.Np % jobInfo.Nn;
            int n3 = this.myNextBackendNumber;
            do {
                int n4 = n;
                if (jobInfo.nodeCount < n2) {
                    ++n4;
                }
                BackendInfo backendInfo = this.myBackendInfo[n3];
                if (backendInfo.state != BackendInfo.State.IDLE || backendInfo.totalCpus < n4) continue;
                backendInfo.state = BackendInfo.State.RESERVED;
                backendInfo.stateTime = l;
                backendInfo.job = jobInfo;
                int n5 = backendInfo.totalCpus / n4;
                int n6 = backendInfo.totalCpus % n4;
                for (int i = 0; i < n4; ++i) {
                    int n7 = jobInfo.Nt;
                    if (n7 == 0) {
                        n7 = n5;
                        if (i < n6) {
                            ++n7;
                        }
                    }
                    this.myLog.log(l, "Job " + jobInfo.jobnum + " assigned " + backendInfo.name + ", rank=" + jobInfo.count + ", CPUs=" + n7);
                    jobInfo.backend[jobInfo.count] = backendInfo;
                    jobInfo.cpus[jobInfo.count] = n7;
                    ++jobInfo.count;
                    jobInfo.frontend.assignBackend(this, backendInfo.name, backendInfo.host, backendInfo.jvm, backendInfo.classpath, backendInfo.jvmflags, backendInfo.shellCommand, n7);
                }
                ++jobInfo.nodeCount;
            } while ((n3 = (n3 + 1) % this.myBackendCount) != this.myNextBackendNumber && jobInfo.count < jobInfo.Np);
            this.myNextBackendNumber = n3;
            if (jobInfo.count != jobInfo.Np) break;
            this.myLog.log(l, "Job " + jobInfo.jobnum + " started");
            iterator.remove();
            this.myRunningJobList.add(jobInfo);
            jobInfo.state = JobInfo.State.RUNNING;
            jobInfo.stateTime = l;
            for (BackendInfo backendInfo : jobInfo.backend) {
                backendInfo.state = BackendInfo.State.RUNNING;
                backendInfo.stateTime = l;
            }
            if (this.myJobTime <= 0) continue;
            jobInfo.jobTimer.start((long)this.myJobTime * 1000L);
        }
        for (JobInfo jobInfo : linkedList) {
            this.doCancelJobTooFewResources(l, jobInfo);
        }
    }

    private boolean enoughResourcesForJob(int n, int n2, int n3) {
        int n4 = (n2 + n - 1) / n;
        if (n3 == 0) {
            n3 = 1;
        }
        int n5 = 0;
        for (BackendInfo backendInfo : this.myBackendInfo) {
            if (backendInfo.state == BackendInfo.State.FAILED || backendInfo.totalCpus < n4 * n3) continue;
            ++n5;
        }
        return n5 >= n;
    }

    private void processHttpRequest(HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        long l = System.currentTimeMillis();
        if (!httpRequest.isValid()) {
            httpResponse.setStatusCode(HttpResponse.Status.STATUS_400_BAD_REQUEST);
            PrintWriter printWriter = httpResponse.getPrintWriter();
            this.printStatusHtmlStart(printWriter, l);
            printWriter.println("<P>");
            printWriter.println("400 Bad Request");
            this.printStatusHtmlEnd(printWriter);
        } else if (!httpRequest.getMethod().equals("GET")) {
            httpResponse.setStatusCode(HttpResponse.Status.STATUS_501_NOT_IMPLEMENTED);
            PrintWriter printWriter = httpResponse.getPrintWriter();
            this.printStatusHtmlStart(printWriter, l);
            printWriter.println("<P>");
            printWriter.println("501 Not Implemented");
            this.printStatusHtmlEnd(printWriter);
        } else if (httpRequest.getUri().equals("/") || httpRequest.getUri().equals("/?")) {
            PrintWriter printWriter = httpResponse.getPrintWriter();
            this.printStatusHtmlStart(printWriter, l);
            this.printStatusHtmlBody(printWriter, l);
            this.printStatusHtmlEnd(printWriter);
        } else if (httpRequest.getUri().equals("/debug")) {
            PrintWriter printWriter = httpResponse.getPrintWriter();
            this.printDebugHtmlStart(printWriter, l);
            this.printDebugHtmlBody(printWriter);
            this.printStatusHtmlEnd(printWriter);
        } else if (httpRequest.getUri().startsWith("/job/")) {
            String string = httpRequest.getUri().substring(5);
            try {
                int n = Integer.parseInt(string);
                PrintWriter printWriter = httpResponse.getPrintWriter();
                this.printJobDetailHtmlStart(printWriter, l, n);
                this.printJobDetailHtmlBody(printWriter, l, n);
                this.printStatusHtmlEnd(printWriter);
            }
            catch (NumberFormatException numberFormatException) {
                PrintWriter printWriter = httpResponse.getPrintWriter();
                this.printErrorHtmlStart(printWriter);
                printWriter.printf("<P>Invalid job number \"%s\"</P>\n", string);
                this.printErrorHtmlEnd(printWriter);
            }
        } else {
            httpResponse.setStatusCode(HttpResponse.Status.STATUS_404_NOT_FOUND);
            PrintWriter printWriter = httpResponse.getPrintWriter();
            this.printErrorHtmlStart(printWriter);
            printWriter.println("<P>404 Not Found</P>");
            this.printErrorHtmlEnd(printWriter);
        }
        httpResponse.close();
    }

    private void printStatusHtmlStart(PrintWriter printWriter, long l) {
        printWriter.println("<HTML>");
        printWriter.println("<HEAD>");
        printWriter.print("<TITLE>");
        printWriter.print(this.myClusterName);
        printWriter.println("</TITLE>");
        printWriter.print("<META HTTP-EQUIV=\"refresh\" CONTENT=\"20;url=");
        this.printWebInterfaceURL(printWriter);
        printWriter.println("\">");
        printWriter.println("<STYLE TYPE=\"text/css\">");
        printWriter.println("<!--");
        printWriter.println("* {font-family: Arial, Helvetica, Sans-Serif;}");
        printWriter.println("body {font-size: small;}");
        printWriter.println("h1 {font-size: 140%; font-weight: bold;}");
        printWriter.println("table {font-size: 100%;}");
        printWriter.println("-->");
        printWriter.println("</STYLE>");
        printWriter.println("</HEAD>");
        printWriter.println("<BODY>");
        printWriter.print("<H1>");
        printWriter.print(this.myClusterName);
        printWriter.println("</H1>");
        printWriter.println("<P>");
        printWriter.print("<FORM ACTION=\"");
        this.printWebInterfaceURL(printWriter);
        printWriter.println("\" METHOD=\"get\">");
        printWriter.println("<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>");
        printWriter.println("<TR>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"center\">");
        printWriter.print("<INPUT TYPE=\"submit\" VALUE=\"Refresh\">");
        printWriter.println("</TD>");
        printWriter.println("<TD WIDTH=20> </TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"center\">");
        printWriter.print(new Date(l));
        printWriter.print(" -- ");
        printWriter.print("Parallel Java v20120620");
        printWriter.println("</TD>");
        printWriter.println("</TR>");
        printWriter.println("</TABLE>");
        printWriter.println("</FORM>");
    }

    private synchronized void printStatusHtmlBody(PrintWriter printWriter, long l) {
        printWriter.println("<P>");
        printWriter.println("<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>");
        printWriter.println("<TR>");
        printWriter.println("<TD ALIGN=\"center\" VALIGN=\"top\">");
        printWriter.println("Nodes");
        printWriter.println("<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0>");
        printWriter.println("<TR>");
        printWriter.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.println("<TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0>");
        this.printBackendLabels(printWriter);
        int n = 0;
        for (BackendInfo backendInfo : this.myBackendInfo) {
            this.printBackendInfo(printWriter, l, backendInfo, n);
            ++n;
        }
        printWriter.println("</TABLE>");
        printWriter.println("</TD>");
        printWriter.println("</TR>");
        printWriter.println("</TABLE>");
        printWriter.println("</TD>");
        printWriter.println("<TD WIDTH=40> </TD>");
        printWriter.println("<TD ALIGN=\"center\" VALIGN=\"top\">");
        printWriter.println("Jobs");
        printWriter.println("<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0>");
        printWriter.println("<TR>");
        printWriter.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.println("<TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0>");
        this.printJobLabels(printWriter);
        n = 0;
        for (JobInfo jobInfo : this.myRunningJobList) {
            this.printJobInfo(printWriter, l, jobInfo, n);
            ++n;
        }
        for (JobInfo jobInfo : this.myWaitingJobList) {
            this.printJobInfo(printWriter, l, jobInfo, n);
            ++n;
        }
        printWriter.println("</TABLE>");
        printWriter.println("</TD>");
        printWriter.println("</TR>");
        printWriter.println("</TABLE>");
        this.printTotalComputeTime(printWriter);
        printWriter.print("<BR>");
        this.printJobCount(printWriter);
        printWriter.println("<BR>Since " + new Date(this.myStartDateTime));
        printWriter.println("</TD>");
        printWriter.println("</TR>");
        printWriter.println("</TABLE>");
    }

    private void printJobCount(PrintWriter printWriter) {
        if (this.myNextJobNumber == 2) {
            printWriter.print("1 job");
        } else {
            printWriter.print(this.myNextJobNumber - 1);
            printWriter.print(" jobs");
        }
        printWriter.println(" served");
    }

    private void printTotalComputeTime(PrintWriter printWriter) {
        if (this.myTotalComputeTime < 1000000L) {
            printWriter.print(this.myTotalComputeTime / 1000L);
        } else if (this.myTotalComputeTime < 1000000000L) {
            printWriter.print("Over ");
            printWriter.print(this.myTotalComputeTime / 1000000L);
            printWriter.print(" thousand");
        } else if (this.myTotalComputeTime < 1000000000000L) {
            printWriter.print("Over ");
            printWriter.print(this.myTotalComputeTime / 1000000000L);
            printWriter.print(" million");
        } else if (this.myTotalComputeTime < 1000000000000000L) {
            printWriter.print("Over ");
            printWriter.print(this.myTotalComputeTime / 1000000000000L);
            printWriter.print(" billion");
        } else {
            printWriter.print("Over ");
            printWriter.print(this.myTotalComputeTime / 1000000000000000L);
            printWriter.print(" trillion");
        }
        printWriter.println(" CPU seconds served");
    }

    private void printStatusHtmlEnd(PrintWriter printWriter) {
        printWriter.println("<P>");
        printWriter.println("<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>");
        printWriter.println("<TR>");
        printWriter.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.println("Job queue web interface:&nbsp;&nbsp;");
        printWriter.println("</TD>");
        printWriter.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<A HREF=\"");
        this.printWebInterfaceURL(printWriter);
        printWriter.print("\">");
        this.printWebInterfaceURL(printWriter);
        printWriter.println("</A>");
        printWriter.println("</TD>");
        printWriter.println("</TR>");
        printWriter.println("<TR>");
        printWriter.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.println("Powered by Parallel Java:&nbsp;&nbsp;");
        printWriter.println("</TD>");
        printWriter.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.println("<A HREF=\"http://www.cs.rit.edu/~ark/pj.shtml\">http://www.cs.rit.edu/~ark/pj.shtml</A>");
        printWriter.println("</TD>");
        printWriter.println("</TR>");
        printWriter.println("<TR>");
        printWriter.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.println("Developed by Alan Kaminsky:&nbsp;&nbsp;");
        printWriter.println("</TD>");
        printWriter.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.println("<A HREF=\"http://www.cs.rit.edu/~ark/\">http://www.cs.rit.edu/~ark/</A>");
        printWriter.println("</TD>");
        printWriter.println("</TR>");
        printWriter.println("</TABLE>");
        printWriter.println("</BODY>");
        printWriter.println("</HTML>");
    }

    private void printWebInterfaceURL(PrintWriter printWriter) {
        printWriter.printf("http://%s:%d/", this.myWebHost, this.myWebPort);
    }

    private void printJobNumberURL(PrintWriter printWriter, int n) {
        printWriter.printf("http://%s:%d/job/%d", this.myWebHost, this.myWebPort, n);
    }

    private void printJobNumberLink(PrintWriter printWriter, int n) {
        printWriter.printf("<A HREF=\"http://%s:%d/job/%d\">&nbsp;%d&nbsp;</A>", this.myWebHost, this.myWebPort, n, n);
    }

    private void printDeltaTime(PrintWriter printWriter, long l, long l2) {
        printWriter.print((l - l2 + 500L) / 1000L);
        printWriter.print(" sec");
    }

    private void printBackendLabels(PrintWriter printWriter) {
        printWriter.println("<TR BGCOLOR=\"#E8E8E8\">");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>Node</I>");
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>CPUs</I>");
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>Status</I>");
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>Job</I>");
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>Time</I>");
        printWriter.println("</TD>");
        printWriter.println("</TR>");
    }

    private void printBackendInfo(PrintWriter printWriter, long l, BackendInfo backendInfo, int n) {
        printWriter.print("<TR BGCOLOR=\"#");
        printWriter.print(n % 2 == 0 ? "FFFFFF" : "E8E8E8");
        printWriter.println("\">");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print(backendInfo.name);
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print(backendInfo.totalCpus);
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        if (backendInfo.state == BackendInfo.State.FAILED) {
            printWriter.print("<FONT COLOR=\"#FF0000\"><B>");
            printWriter.print((Object)backendInfo.state);
            printWriter.print("</B></FONT>");
        } else {
            printWriter.print((Object)backendInfo.state);
        }
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        if (backendInfo.job != null) {
            this.printJobNumberLink(printWriter, backendInfo.job.jobnum);
        } else {
            printWriter.print("&nbsp;");
        }
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        if (backendInfo.job != null) {
            this.printDeltaTime(printWriter, l, backendInfo.job.stateTime);
        } else {
            printWriter.print("&nbsp;");
        }
        printWriter.println("</TD>");
        printWriter.println("</TR>");
    }

    private void printJobLabels(PrintWriter printWriter) {
        printWriter.println("<TR BGCOLOR=\"#E8E8E8\">");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>Job</I>");
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>User</I>");
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>nn</I>");
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>np</I>");
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>nt</I>");
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>Rank</I>");
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>Node</I>");
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>CPUs</I>");
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>Status</I>");
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>Time</I>");
        printWriter.println("</TD>");
        printWriter.println("</TR>");
    }

    private void printJobInfo(PrintWriter printWriter, long l, JobInfo jobInfo, int n) {
        int n2;
        printWriter.print("<TR BGCOLOR=\"#");
        printWriter.print(n % 2 == 0 ? "FFFFFF" : "E8E8E8");
        printWriter.println("\">");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        this.printJobNumberLink(printWriter, jobInfo.jobnum);
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print(jobInfo.username);
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print(jobInfo.Nn);
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print(jobInfo.Np);
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print(jobInfo.Nt == 0 ? "all" : "" + jobInfo.Nt);
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        if (jobInfo.count == 0) {
            printWriter.print("&nbsp;");
        } else {
            for (n2 = 0; n2 < jobInfo.count; ++n2) {
                if (n2 > 0) {
                    printWriter.print("<BR>");
                }
                printWriter.print(n2);
            }
        }
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        if (jobInfo.count == 0) {
            printWriter.print("&nbsp;");
        } else {
            for (n2 = 0; n2 < jobInfo.count; ++n2) {
                if (n2 > 0) {
                    printWriter.print("<BR>");
                }
                printWriter.print(jobInfo.backend[n2].name);
            }
        }
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        if (jobInfo.count == 0) {
            printWriter.print("&nbsp;");
        } else {
            for (n2 = 0; n2 < jobInfo.count; ++n2) {
                if (n2 > 0) {
                    printWriter.print("<BR>");
                }
                printWriter.print(jobInfo.cpus[n2]);
            }
        }
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print((Object)jobInfo.state);
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        this.printDeltaTime(printWriter, l, jobInfo.stateTime);
        printWriter.println("</TD>");
        printWriter.println("</TR>");
    }

    private void printDebugHtmlStart(PrintWriter printWriter, long l) {
        printWriter.println("<HTML>");
        printWriter.println("<HEAD>");
        printWriter.print("<TITLE>");
        printWriter.print(this.myClusterName);
        printWriter.println("</TITLE>");
        printWriter.println("<STYLE TYPE=\"text/css\">");
        printWriter.println("<!--");
        printWriter.println("* {font-family: Arial, Helvetica, Sans-Serif;}");
        printWriter.println("body {font-size: small;}");
        printWriter.println("h1 {font-size: 140%; font-weight: bold;}");
        printWriter.println("table {font-size: 100%;}");
        printWriter.println("-->");
        printWriter.println("</STYLE>");
        printWriter.println("</HEAD>");
        printWriter.println("<BODY>");
        printWriter.print("<H1>");
        printWriter.print(this.myClusterName);
        printWriter.println("</H1>");
        printWriter.println("<P>");
        printWriter.print(new Date(l));
        printWriter.print(" -- ");
        printWriter.print("Parallel Java v20120620");
        printWriter.println("</P>");
    }

    private void printDebugHtmlBody(PrintWriter printWriter) {
        printWriter.println("<P>");
        printWriter.println("<HR/>");
        printWriter.println("<H3>Thread Dump</H3>");
        printWriter.println("</P>");
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
            Thread thread = entry.getKey();
            printWriter.println("<P>");
            printWriter.print("Name: ");
            printWriter.print(thread.getName());
            printWriter.println("&nbsp;&nbsp;&nbsp;&nbsp;");
            printWriter.print(" ID: ");
            printWriter.print(thread.getId());
            printWriter.println("&nbsp;&nbsp;&nbsp;&nbsp;");
            printWriter.print(" Daemon: ");
            printWriter.print(thread.isDaemon() ? "yes" : "no");
            printWriter.println("&nbsp;&nbsp;&nbsp;&nbsp;");
            printWriter.print(" State: ");
            printWriter.print((Object)thread.getState());
            printWriter.println("&nbsp;&nbsp;&nbsp;&nbsp;");
            printWriter.print(" Priority: ");
            printWriter.print(thread.getPriority());
            printWriter.println("&nbsp;&nbsp;&nbsp;&nbsp;");
            printWriter.print(" Thread Group: ");
            printWriter.print(thread.getThreadGroup().getName());
            printWriter.println();
            for (StackTraceElement stackTraceElement : entry.getValue()) {
                printWriter.print("<BR/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                printWriter.println(stackTraceElement);
            }
            printWriter.println("</P>");
        }
        printWriter.println("<P>");
        printWriter.println("<HR/>");
        printWriter.println("</P>");
    }

    private void printJobDetailHtmlStart(PrintWriter printWriter, long l, int n) {
        printWriter.println("<HTML>");
        printWriter.println("<HEAD>");
        printWriter.print("<TITLE>");
        printWriter.print(this.myClusterName);
        printWriter.println("</TITLE>");
        printWriter.print("<META HTTP-EQUIV=\"refresh\" CONTENT=\"20;url=");
        this.printJobNumberURL(printWriter, n);
        printWriter.println("\">");
        printWriter.println("<STYLE TYPE=\"text/css\">");
        printWriter.println("<!--");
        printWriter.println("* {font-family: Arial, Helvetica, Sans-Serif;}");
        printWriter.println("body {font-size: small;}");
        printWriter.println("h1 {font-size: 140%; font-weight: bold;}");
        printWriter.println("table {font-size: 100%;}");
        printWriter.println("-->");
        printWriter.println("</STYLE>");
        printWriter.println("</HEAD>");
        printWriter.println("<BODY>");
        printWriter.print("<H1>");
        printWriter.print(this.myClusterName);
        printWriter.println("</H1>");
        printWriter.println("<P>");
        printWriter.print("<FORM ACTION=\"");
        this.printJobNumberURL(printWriter, n);
        printWriter.println("\" METHOD=\"get\">");
        printWriter.println("<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>");
        printWriter.println("<TR>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"center\">");
        printWriter.print("<INPUT TYPE=\"submit\" VALUE=\"Refresh\">");
        printWriter.println("</TD>");
        printWriter.println("<TD WIDTH=20> </TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"center\">");
        printWriter.print(new Date(l));
        printWriter.print(" -- ");
        printWriter.print("Parallel Java v20120620");
        printWriter.println("</TD>");
        printWriter.println("</TR>");
        printWriter.println("</TABLE>");
        printWriter.println("</FORM>");
    }

    private synchronized void printJobDetailHtmlBody(PrintWriter printWriter, long l, int n) {
        JobInfo jobInfo = null;
        for (JobInfo jobInfo2 : this.myRunningJobList) {
            if (jobInfo2.jobnum != n) continue;
            jobInfo = jobInfo2;
            break;
        }
        if (jobInfo == null) {
            for (JobInfo jobInfo2 : this.myWaitingJobList) {
                if (jobInfo2.jobnum != n) continue;
                jobInfo = jobInfo2;
                break;
            }
        }
        printWriter.println("<P>");
        printWriter.println("<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>");
        printWriter.println("<TR>");
        printWriter.println("<TD ALIGN=\"left\" VALIGN=\"top\"><B>Job:</B></TD>");
        printWriter.println("<TD WIDTH=10> </TD>");
        printWriter.printf("<TD ALIGN=\"left\" VALIGN=\"top\"><B>%d</B></TD>", n);
        printWriter.println("</TR>");
        printWriter.println("<TR>");
        printWriter.println("<TD ALIGN=\"left\" VALIGN=\"top\">User:</TD>");
        printWriter.println("<TD WIDTH=10> </TD>");
        printWriter.printf("<TD ALIGN=\"left\" VALIGN=\"top\">%s</TD>", jobInfo == null ? " " : jobInfo.username);
        printWriter.println("</TR>");
        printWriter.println("<TR>");
        printWriter.println("<TD ALIGN=\"left\" VALIGN=\"top\">Nodes (nn):</TD>");
        printWriter.println("<TD WIDTH=10> </TD>");
        printWriter.printf("<TD ALIGN=\"left\" VALIGN=\"top\">%s</TD>", jobInfo == null ? " " : "" + jobInfo.Nn);
        printWriter.println("</TR>");
        printWriter.println("<TR>");
        printWriter.println("<TD ALIGN=\"left\" VALIGN=\"top\">Processes (np):</TD>");
        printWriter.println("<TD WIDTH=10> </TD>");
        printWriter.printf("<TD ALIGN=\"left\" VALIGN=\"top\">%s</TD>", jobInfo == null ? " " : "" + jobInfo.Np);
        printWriter.println("</TR>");
        printWriter.println("<TR>");
        printWriter.println("<TD ALIGN=\"left\" VALIGN=\"top\">Threads (nt):</TD>");
        printWriter.println("<TD WIDTH=10> </TD>");
        printWriter.printf("<TD ALIGN=\"left\" VALIGN=\"top\">%s</TD>", jobInfo == null ? " " : (jobInfo.Nt == 0 ? "All" : "" + jobInfo.Nt));
        printWriter.println("</TR>");
        printWriter.println("<TR>");
        printWriter.println("<TD ALIGN=\"left\" VALIGN=\"top\">Status:</TD>");
        printWriter.println("<TD WIDTH=10> </TD>");
        printWriter.printf("<TD ALIGN=\"left\" VALIGN=\"top\">%s</TD>", jobInfo == null ? "Not in queue" : jobInfo.state);
        printWriter.println("</TR>");
        printWriter.println("<TR>");
        printWriter.println("<TD ALIGN=\"left\" VALIGN=\"top\">Time:</TD>");
        printWriter.println("<TD WIDTH=10> </TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        if (jobInfo == null) {
            printWriter.print(" ");
        } else {
            this.printDeltaTime(printWriter, l, jobInfo.stateTime);
        }
        printWriter.println("</TD>");
        printWriter.println("</TR>");
        printWriter.println("</TABLE>");
        printWriter.println("</P>");
        if (jobInfo == null || jobInfo.count == 0) {
            return;
        }
        printWriter.println("<P>");
        printWriter.println("<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>");
        printWriter.println("<TR>");
        printWriter.println("<TD ALIGN=\"center\" VALIGN=\"top\">");
        printWriter.println("Processes");
        printWriter.println("<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0>");
        printWriter.println("<TR>");
        printWriter.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.println("<TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0>");
        this.printJobDetailProcessLabels(printWriter);
        for (int i = 0; i < jobInfo.count; ++i) {
            this.printJobDetailProcessInfo(printWriter, jobInfo, i);
        }
        printWriter.println("</TABLE>");
        printWriter.println("</TD>");
        printWriter.println("</TR>");
        printWriter.println("</TABLE>");
        printWriter.println("</TD>");
        printWriter.println("</TR>");
        printWriter.println("</TABLE>");
        printWriter.println("</P>");
    }

    private void printJobDetailProcessLabels(PrintWriter printWriter) {
        printWriter.println("<TR BGCOLOR=\"#E8E8E8\">");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>Rank</I>");
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>Node</I>");
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>CPUs</I>");
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>Comment</I>");
        printWriter.println("</TD>");
        printWriter.println("</TR>");
    }

    private void printJobDetailProcessInfo(PrintWriter printWriter, JobInfo jobInfo, int n) {
        printWriter.printf("<TR BGCOLOR=\"#%s\">\n", n % 2 == 0 ? "FFFFFF" : "E8E8E8");
        printWriter.printf("<TD ALIGN=\"left\" VALIGN=\"top\">%d&nbsp;&nbsp;</TD>\n", n);
        printWriter.printf("<TD ALIGN=\"left\" VALIGN=\"top\">%s&nbsp;&nbsp;</TD>\n", jobInfo.backend[n].name);
        printWriter.printf("<TD ALIGN=\"left\" VALIGN=\"top\">%d&nbsp;&nbsp;</TD>\n", jobInfo.cpus[n]);
        printWriter.printf("<TD ALIGN=\"left\" VALIGN=\"top\">%s</TD>\n", jobInfo.comment[n]);
        printWriter.println("</TR>");
    }

    private void printErrorHtmlStart(PrintWriter printWriter) {
        printWriter.println("<HTML>");
        printWriter.println("<HEAD>");
        printWriter.print("<TITLE>");
        printWriter.print(this.myClusterName);
        printWriter.println("</TITLE>");
        printWriter.println("<STYLE TYPE=\"text/css\">");
        printWriter.println("<!--");
        printWriter.println("* {font-family: Arial, Helvetica, Sans-Serif;}");
        printWriter.println("body {font-size: small;}");
        printWriter.println("h1 {font-size: 140%; font-weight: bold;}");
        printWriter.println("table {font-size: 100%;}");
        printWriter.println("-->");
        printWriter.println("</STYLE>");
        printWriter.println("</HEAD>");
        printWriter.println("<BODY>");
    }

    private void printErrorHtmlEnd(PrintWriter printWriter) {
        printWriter.println("</BODY>");
        printWriter.println("</HTML>");
    }

    private void shutdown() {
        if (this.myChannelGroup != null) {
            this.myChannelGroup.close();
        }
        if (this.myHttpServer != null) {
            try {
                this.myHttpServer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.myLog.log("Stopped");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.err.println("Usage: java edu.rit.pj.cluster.JobScheduler <configfile>");
            System.exit(1);
        }
        JobScheduler jobScheduler = new JobScheduler(stringArray[0]);
        jobScheduler.run();
    }
}

