/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.mp.ByteBuf;
import edu.rit.pj.cluster.JobBackendProxy;
import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontend;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;

public class FrontendFileWriter {
    private JobFrontend myJobFrontend;
    private Map<Integer, FileHandler> myFileHandlerForFFD = new HashMap<Integer, FileHandler>();
    private int myNextFFD = 3;

    public FrontendFileWriter(JobFrontend jobFrontend) {
        this.myJobFrontend = jobFrontend;
        this.myFileHandlerForFFD.put(1, new FileHandler(System.out));
        this.myFileHandlerForFFD.put(2, new FileHandler(System.err));
    }

    public void outputFileOpen(JobBackendRef jobBackendRef, int n, File file, boolean bl) throws IOException {
        new FileHandler().outputFileOpen(jobBackendRef, n, file, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputFileWrite(JobBackendRef jobBackendRef, int n, int n2) throws IOException {
        FileHandler fileHandler = null;
        Map<Integer, FileHandler> map = this.myFileHandlerForFFD;
        synchronized (map) {
            fileHandler = this.myFileHandlerForFFD.get(n);
        }
        if (fileHandler != null) {
            fileHandler.outputFileWrite(jobBackendRef, n, n2);
        } else {
            jobBackendRef.outputFileWriteResult(this.myJobFrontend, n, new IOException("File closed, ffd=" + n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputFileFlush(JobBackendRef jobBackendRef, int n) throws IOException {
        FileHandler fileHandler = null;
        Map<Integer, FileHandler> map = this.myFileHandlerForFFD;
        synchronized (map) {
            fileHandler = this.myFileHandlerForFFD.get(n);
        }
        if (fileHandler != null) {
            fileHandler.outputFileFlush(jobBackendRef, n);
        } else {
            jobBackendRef.outputFileFlushResult(this.myJobFrontend, n, new IOException("File closed, ffd=" + n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputFileClose(JobBackendRef jobBackendRef, int n) throws IOException {
        FileHandler fileHandler = null;
        Map<Integer, FileHandler> map = this.myFileHandlerForFFD;
        synchronized (map) {
            fileHandler = this.myFileHandlerForFFD.get(n);
        }
        if (fileHandler != null) {
            fileHandler.outputFileClose(jobBackendRef, n);
        } else {
            jobBackendRef.outputFileCloseResult(this.myJobFrontend, n, new IOException("File closed, ffd=" + n));
        }
    }

    private class FileHandler
    extends Thread {
        private LinkedBlockingQueue<Invocation> myQueue = new LinkedBlockingQueue();
        private OutputStream myOutputStream;
        private byte[] myByteArray = new byte[0];
        private ByteBuf myByteBuf = ByteBuf.buffer(this.myByteArray);

        public FileHandler() {
            this.setDaemon(true);
            this.start();
        }

        public FileHandler(OutputStream outputStream) {
            this.myOutputStream = outputStream;
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            try {
                while (this.myQueue.take().invoke()) {
                }
            }
            catch (Throwable throwable) {
                FrontendFileWriter.this.myJobFrontend.terminateCancelJobOther(throwable);
            }
        }

        public void outputFileOpen(JobBackendRef jobBackendRef, int n, File file, boolean bl) {
            this.myQueue.offer(new OutputFileOpenInvocation(jobBackendRef, n, file, bl));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean invokeOutputFileOpen(JobBackendRef jobBackendRef, int n, File file, boolean bl) throws IOException {
            int n2 = 0;
            IOException iOException = null;
            boolean bl2 = false;
            try {
                this.myOutputStream = new FileOutputStream(file, bl);
                Map map = FrontendFileWriter.this.myFileHandlerForFFD;
                synchronized (map) {
                    n2 = FrontendFileWriter.this.myNextFFD++;
                    FrontendFileWriter.this.myFileHandlerForFFD.put(n2, this);
                }
                bl2 = true;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            jobBackendRef.outputFileOpenResult(FrontendFileWriter.this.myJobFrontend, n, n2, iOException);
            return bl2;
        }

        public void outputFileWrite(JobBackendRef jobBackendRef, int n, int n2) {
            this.myQueue.offer(new OutputFileWriteInvocation(jobBackendRef, n, n2));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean invokeOutputFileWrite(JobBackendRef jobBackendRef, int n, int n2) throws IOException {
            IOException iOException = null;
            boolean bl = false;
            try {
                if (this.myByteArray.length < n2) {
                    this.myByteArray = new byte[n2];
                    this.myByteBuf = ByteBuf.buffer(this.myByteArray);
                }
                ((JobBackendProxy)jobBackendRef).receive(n, this.myByteBuf);
                this.myOutputStream.write(this.myByteArray, 0, n2);
                bl = true;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                try {
                    this.myOutputStream.close();
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                Map map = FrontendFileWriter.this.myFileHandlerForFFD;
                synchronized (map) {
                    FrontendFileWriter.this.myFileHandlerForFFD.remove(n);
                }
            }
            jobBackendRef.outputFileWriteResult(FrontendFileWriter.this.myJobFrontend, n, iOException);
            return bl;
        }

        public void outputFileFlush(JobBackendRef jobBackendRef, int n) {
            this.myQueue.offer(new OutputFileFlushInvocation(jobBackendRef, n));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean invokeOutputFileFlush(JobBackendRef jobBackendRef, int n) throws IOException {
            IOException iOException = null;
            boolean bl = false;
            try {
                this.myOutputStream.flush();
                bl = true;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                try {
                    this.myOutputStream.close();
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                Map map = FrontendFileWriter.this.myFileHandlerForFFD;
                synchronized (map) {
                    FrontendFileWriter.this.myFileHandlerForFFD.remove(n);
                }
            }
            jobBackendRef.outputFileFlushResult(FrontendFileWriter.this.myJobFrontend, n, iOException);
            return bl;
        }

        public void outputFileClose(JobBackendRef jobBackendRef, int n) {
            this.myQueue.offer(new OutputFileCloseInvocation(jobBackendRef, n));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean invokeOutputFileClose(JobBackendRef jobBackendRef, int n) throws IOException {
            IOException iOException = null;
            try {
                this.myOutputStream.close();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            Map map = FrontendFileWriter.this.myFileHandlerForFFD;
            synchronized (map) {
                FrontendFileWriter.this.myFileHandlerForFFD.remove(n);
            }
            jobBackendRef.outputFileCloseResult(FrontendFileWriter.this.myJobFrontend, n, iOException);
            return false;
        }

        private class OutputFileCloseInvocation
        extends Invocation {
            private JobBackendRef theJobBackend;
            private int ffd;

            public OutputFileCloseInvocation(JobBackendRef jobBackendRef, int n) {
                this.theJobBackend = jobBackendRef;
                this.ffd = n;
            }

            public boolean invoke() throws IOException {
                return FileHandler.this.invokeOutputFileClose(this.theJobBackend, this.ffd);
            }
        }

        private class OutputFileFlushInvocation
        extends Invocation {
            private JobBackendRef theJobBackend;
            private int ffd;

            public OutputFileFlushInvocation(JobBackendRef jobBackendRef, int n) {
                this.theJobBackend = jobBackendRef;
                this.ffd = n;
            }

            public boolean invoke() throws IOException {
                return FileHandler.this.invokeOutputFileFlush(this.theJobBackend, this.ffd);
            }
        }

        private class OutputFileWriteInvocation
        extends Invocation {
            private JobBackendRef theJobBackend;
            private int ffd;
            private int len;

            public OutputFileWriteInvocation(JobBackendRef jobBackendRef, int n, int n2) {
                this.theJobBackend = jobBackendRef;
                this.ffd = n;
                this.len = n2;
            }

            public boolean invoke() throws IOException {
                return FileHandler.this.invokeOutputFileWrite(this.theJobBackend, this.ffd, this.len);
            }
        }

        private class OutputFileOpenInvocation
        extends Invocation {
            private JobBackendRef theJobBackend;
            private int bfd;
            private File file;
            private boolean append;

            public OutputFileOpenInvocation(JobBackendRef jobBackendRef, int n, File file, boolean bl) {
                this.theJobBackend = jobBackendRef;
                this.bfd = n;
                this.file = file;
                this.append = bl;
            }

            public boolean invoke() throws IOException {
                return FileHandler.this.invokeOutputFileOpen(this.theJobBackend, this.bfd, this.file, this.append);
            }
        }

        private abstract class Invocation {
            private Invocation() {
            }

            public abstract boolean invoke() throws IOException;
        }
    }
}

