/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.numeric.BigRational;
import edu.rit.numeric.Function;
import edu.rit.numeric.Series;
import java.math.BigInteger;

public class Statistics {
    private static final double INV_SQRT_2 = 1.0 / Math.sqrt(2.0);
    private static final double[] LGAMMA_COF = new double[]{57.15623566586292, -59.59796035547549, 14.136097974741746, -0.4919138160976202, 3.399464998481189E-5, 4.652362892704858E-5, -9.837447530487956E-5, 1.580887032249125E-4, -2.1026444172410488E-4, 2.1743961811521265E-4, -1.643181065367639E-4, 8.441822398385275E-5, -2.6190838401581408E-5, 3.6899182659531625E-6};
    private static final int GAMMA_ITMAX = 200;
    private static final double GAMMA_EPS = 2.22E-16;
    private static final double GAMMA_FPMIN = 1.0045045045045045E-292;
    private static final int BETA_ITMAX = 10000;
    private static final double BETA_EPS = 2.22E-16;
    private static final double BETA_FPMIN = 1.0045045045045045E-292;

    private Statistics() {
    }

    public static double chiSquareTest(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray[i] - dArray2[i];
            d += d2 * d2 / dArray2[i];
        }
        return d;
    }

    public static double chiSquarePvalue(double d, double d2) {
        return Statistics.gammq(0.5 * d, 0.5 * d2);
    }

    public static double bernoulliChiSquareTest(long l, long l2) {
        double d = 0.5 * (double)l;
        double d2 = (double)l2 - d;
        return 2.0 * d2 * d2 / d;
    }

    public static double bernoulliChiSquarePvalue(double d) {
        return Statistics.gammq(0.5, 0.5 * d);
    }

    public static double ySquareTest(int n, double[] dArray, double[] dArray2) {
        double d = 2.0 * (double)n;
        double d2 = 0.0;
        for (int i = 0; i < dArray2.length; ++i) {
            d2 += 1.0 / dArray2[i];
        }
        return (double)n + Math.sqrt(d / (d + d2)) * (Statistics.chiSquareTest(dArray, dArray2) - (double)n);
    }

    public static double ySquarePvalue(double d, double d2) {
        return Statistics.gammq(0.5 * d, 0.5 * d2);
    }

    public static double ksTest(double[] dArray) {
        int n = dArray.length;
        double d = n;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d4 = (double)(i + 1) / d;
            d2 = Math.max(d2, Math.abs(dArray[i] - d3));
            d2 = Math.max(d2, Math.abs(dArray[i] - d4));
            d3 = d4;
        }
        return d2;
    }

    public static double ksTest(double[] dArray, Function function) {
        int n = dArray.length;
        double d = n;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d4 = (double)(i + 1) / d;
            double d5 = function.f(dArray[i]);
            d2 = Math.max(d2, Math.abs(d5 - d3));
            d2 = Math.max(d2, Math.abs(d5 - d4));
            d3 = d4;
        }
        return d2;
    }

    public static double binomialKsTest(int[] nArray, int n) {
        if ((long)n <= 0L) {
            throw new IllegalArgumentException("Statistics.binomialKsTest(): n = " + n + " illegal");
        }
        int n2 = nArray.length;
        BigRational bigRational = new BigRational(0L);
        BigRational bigRational2 = new BigRational();
        BigRational bigRational3 = new BigRational();
        int n3 = 0;
        BigInteger bigInteger = new BigInteger("1");
        BigInteger bigInteger2 = new BigInteger("0");
        BigInteger bigInteger3 = new BigInteger("2").pow(n);
        BigRational bigRational4 = new BigRational(0L);
        int n4 = 0;
        int n5 = 0;
        while (n4 < n2) {
            n5 = n4;
            while (n5 + 1 < n2 && nArray[n5 + 1] == nArray[n4]) {
                ++n5;
            }
            bigRational2.assign(n4, n2);
            bigRational3.assign(n5 + 1, n2);
            while (n3 < nArray[n4]) {
                bigInteger = bigInteger.multiply(BigInteger.valueOf(n - n3));
                bigInteger = bigInteger.divide(BigInteger.valueOf(++n3));
                bigInteger2 = bigInteger2.add(bigInteger);
            }
            bigRational4.assign(bigInteger2, bigInteger3);
            bigRational2.sub(bigRational4).abs();
            bigRational3.sub(bigRational4).abs();
            bigRational.max(bigRational2).max(bigRational3).normalize();
            n4 = n5 + 1;
        }
        return bigRational.doubleValue();
    }

    public static double ksPvalue(double d, double d2) {
        double d3 = Math.sqrt(d);
        double d4 = (d3 + 0.12 + 0.11 / d3) * d2;
        d4 = -2.0 * d4 * d4;
        double d5 = 2.0;
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 1; i <= 100; ++i) {
            double d8 = d5 * Math.exp(d4 * (double)i * (double)i);
            d6 += d8;
            double d9 = Math.abs(d8);
            if (d9 <= 1.0E-6 * d7 || d9 <= 1.0E-12 * d6) {
                return d6;
            }
            d5 = -d5;
            d7 = d9;
        }
        return 1.0;
    }

    public static double normalPvalue(double d, double d2, double d3) {
        return 1.0 - Statistics.erfc(-INV_SQRT_2 * (d - d2) / d3);
    }

    public static double[] tTestUnequalVariance(Series series, Series series2) {
        int n = series.length();
        Series.Stats stats = series.stats();
        double d = stats.mean;
        double d2 = stats.var;
        int n2 = series2.length();
        Series.Stats stats2 = series2.stats();
        double d3 = stats2.mean;
        double d4 = stats2.var;
        double d5 = (d - d3) / Math.sqrt(d2 / (double)n + d4 / (double)n2);
        double d6 = Statistics.sqr(d2 / (double)n + d4 / (double)n2) / (Statistics.sqr(d2 / (double)n) / (double)(n - 1) + Statistics.sqr(d4 / (double)n2) / (double)(n2 - 1));
        double d7 = Statistics.betai(0.5 * d6, 0.5, d6 / (d6 + Statistics.sqr(d5)));
        return new double[]{d5, d7};
    }

    private static double lgamma(double d) {
        double d2 = d;
        double d3 = d + 5.2421875;
        d3 = (d + 0.5) * Math.log(d3) - d3;
        double d4 = 0.9999999999999971;
        for (int i = 0; i < LGAMMA_COF.length; ++i) {
            d4 += LGAMMA_COF[i] / (d2 += 1.0);
        }
        return d3 + Math.log(2.5066282746310007 * d4 / d);
    }

    private static double gser(double d, double d2) {
        double d3;
        double d4 = d;
        double d5 = d3 = 1.0 / d;
        for (int i = 1; i <= 200; ++i) {
            d5 += (d3 *= d2 / (d4 += 1.0));
            if (!(Math.abs(d3) < Math.abs(d5) * 2.22E-16)) continue;
            return d5 * Math.exp(-d2 + d * Math.log(d2) - Statistics.lgamma(d));
        }
        return 1.0;
    }

    private static double gcf(double d, double d2) {
        double d3;
        double d4 = d2 + 1.0 - d;
        double d5 = 9.955156950672646E291;
        double d6 = d3 = 1.0 / d4;
        for (int i = 1; i <= 200; ++i) {
            double d7 = (double)(-i) * ((double)i - d);
            if (Math.abs(d3 = d7 * d3 + (d4 += 2.0)) < 1.0045045045045045E-292) {
                d3 = 1.0045045045045045E-292;
            }
            if (Math.abs(d5 = d4 + d7 / d5) < 1.0045045045045045E-292) {
                d5 = 1.0045045045045045E-292;
            }
            d3 = 1.0 / d3;
            double d8 = d3 * d5;
            d6 *= d8;
            if (!(Math.abs(d8 - 1.0) < 2.22E-16)) continue;
            return Math.exp(-d2 + d * Math.log(d2) - Statistics.lgamma(d)) * d6;
        }
        return 0.0;
    }

    private static double gammp(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("gammp(): a = " + d + " illegal");
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException("gammp(): x = " + d2 + " illegal");
        }
        return d2 == 0.0 ? 0.0 : (d2 < d + 1.0 ? Statistics.gser(d, d2) : 1.0 - Statistics.gcf(d, d2));
    }

    private static double gammq(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("gammq(): a = " + d + " illegal");
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException("gammq(): x = " + d2 + " illegal");
        }
        return d2 == 0.0 ? 1.0 : (d2 < d + 1.0 ? 1.0 - Statistics.gser(d, d2) : Statistics.gcf(d, d2));
    }

    private static double erfc(double d) {
        return Statistics.gammq(0.5, d * d);
    }

    private static double betacf(double d, double d2, double d3) {
        double d4 = d + d2;
        double d5 = d + 1.0;
        double d6 = d - 1.0;
        double d7 = 1.0;
        double d8 = 1.0 - d4 * d3 / d5;
        if (Math.abs(d8) < 1.0045045045045045E-292) {
            d8 = 1.0045045045045045E-292;
        }
        double d9 = d8 = 1.0 / d8;
        for (int i = 1; i < 10000; ++i) {
            int n = 2 * i;
            double d10 = (double)i * (d2 - (double)i) * d3 / ((d6 + (double)n) * (d + (double)n));
            if (Math.abs(d8 = 1.0 + d10 * d8) < 1.0045045045045045E-292) {
                d8 = 1.0045045045045045E-292;
            }
            if (Math.abs(d7 = 1.0 + d10 / d7) < 1.0045045045045045E-292) {
                d7 = 1.0045045045045045E-292;
            }
            d8 = 1.0 / d8;
            d9 *= d8 * d7;
            d10 = -(d + (double)i) * (d4 + (double)i) * d3 / ((d + (double)n) * (d5 + (double)n));
            if (Math.abs(d8 = 1.0 + d10 * d8) < 1.0045045045045045E-292) {
                d8 = 1.0045045045045045E-292;
            }
            if (Math.abs(d7 = 1.0 + d10 / d7) < 1.0045045045045045E-292) {
                d7 = 1.0045045045045045E-292;
            }
            d8 = 1.0 / d8;
            double d11 = d8 * d7;
            d9 *= d11;
            if (Math.abs(d11 - 1.0) <= 2.22E-16) break;
        }
        return d9;
    }

    private static double betai(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("betai(): a = " + d + " illegal");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("betai(): b = " + d2 + " illegal");
        }
        if (d3 < 0.0 || d3 > 1.0) {
            throw new IllegalArgumentException("betai(): x = " + d3 + " illegal");
        }
        if (d3 == 0.0 || d3 == 1.0) {
            return d3;
        }
        double d4 = Math.exp(Statistics.lgamma(d + d2) - Statistics.lgamma(d) - Statistics.lgamma(d2) + d * Math.log(d3) + d2 * Math.log(1.0 - d3));
        if (d3 < (d + 1.0) / (d + d2 + 2.0)) {
            return d4 * Statistics.betacf(d, d2, d3) / d;
        }
        return 1.0 - d4 * Statistics.betacf(d2, d, 1.0 - d3) / d2;
    }

    private static double sqr(double d) {
        return d * d;
    }
}

