/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.numeric.Function;
import edu.rit.numeric.XYSeries;

public class SampledXYSeries
extends XYSeries {
    private Function myFunction;
    private double myXinit;
    private double myDelta;
    private int myLength;

    public SampledXYSeries(Function function, double d, double d2, int n) {
        if (function == null) {
            throw new NullPointerException("SampledXYSeries(): theFunction is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("SampledXYSeries(): len = " + n + " illegal");
        }
        this.myFunction = function;
        this.myXinit = d;
        this.myDelta = d2;
        this.myLength = n;
    }

    public int length() {
        return this.myLength;
    }

    public double x(int n) {
        return this.myXinit + (double)n * this.myDelta;
    }

    public double y(int n) {
        return this.myFunction.f(this.x(n));
    }
}

