/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mri.test;

import edu.rit.mri.PixelAnalysis;
import edu.rit.mri.PixelSignal;
import edu.rit.mri.SignalDataSetReader;
import edu.rit.mri.SpinSignal;
import edu.rit.numeric.AggregateXYSeries;
import edu.rit.numeric.ArraySeries;
import edu.rit.numeric.ListXYSeries;
import edu.rit.numeric.Series;
import edu.rit.numeric.plot.Dots;
import edu.rit.numeric.plot.Plot;
import edu.rit.numeric.plot.Strokes;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Test06 {
    private Test06() {
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        if (stringArray.length != 5) {
            Test06.usage();
        }
        File file = new File(stringArray[0]);
        double d = Double.parseDouble(stringArray[1]);
        double d2 = Double.parseDouble(stringArray[2]);
        int n = Integer.parseInt(stringArray[3]);
        int n2 = Integer.parseInt(stringArray[4]);
        SignalDataSetReader signalDataSetReader = new SignalDataSetReader(file);
        Series series = signalDataSetReader.getTimeSeries();
        int n3 = series.length();
        PixelSignal pixelSignal = signalDataSetReader.getPixelSignal(n2);
        if (pixelSignal == null) {
            System.err.println("Test06: Pixel " + n2 + " has no data");
            System.exit(0);
        }
        Series series2 = pixelSignal.S_measured();
        double[] dArray = new double[n + 1];
        double d3 = Math.log(d);
        double d4 = Math.log(d2);
        double d5 = (d4 - d3) / (double)n;
        for (int i = 0; i <= n; ++i) {
            dArray[i] = Math.exp(d3 + (double)i * d5);
        }
        ArraySeries arraySeries = new ArraySeries(dArray);
        double[][] dArray2 = new double[n3][n + 1];
        for (int i = 0; i < n3; ++i) {
            object = dArray2[i];
            double d6 = series.x(i);
            for (int j = 0; j <= n; ++j) {
                object[j] = SpinSignal.S(dArray[j], d6);
            }
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        object = new ArrayList();
        PixelAnalysis.analyze(series, series2, arraySeries, dArray2, arrayList, (List<Double>)object);
        Test06.printSolution(series, series2, arrayList, (List<Double>)object);
        Plot plot = new Plot();
        plot.xAxisLength(1200.0).xAxisMajorDivisions(20).yAxisLength(600.0).yAxisMajorDivisions(10).seriesDots(Dots.circle(Color.BLACK, null, null, 5.0)).seriesColor(Color.BLACK).seriesStroke(Strokes.solid(2.0)).xySeries(new AggregateXYSeries(series, series2));
        int n4 = arrayList.size();
        if (n4 > 0) {
            ListXYSeries listXYSeries = new ListXYSeries();
            for (int i = 0; i < n3; ++i) {
                double d7 = series.x(i);
                double d8 = 0.0;
                for (int j = 0; j < n4; ++j) {
                    d8 += SpinSignal.S(arrayList.get(j), (Double)((ArrayList)object).get(j), d7);
                }
                listXYSeries.add(d7, d8);
            }
            plot.seriesDots(null).seriesColor(Color.RED).seriesStroke(Strokes.solid(1.0)).xySeries(listXYSeries);
        }
        plot.getFrame().setVisible(true);
    }

    private static void printSolution(Series series, Series series2, List<Double> list, List<Double> list2) {
        int n = series.length();
        int n2 = list.size();
        if (n2 == 0) {
            System.out.println("Test06: Could not find solution");
        } else {
            System.out.println("rho\tR1\tT1");
            for (int i = 0; i < n2; ++i) {
                System.out.print(list.get(i));
                System.out.print('\t');
                System.out.print(list2.get(i));
                System.out.print('\t');
                System.out.print(1.0 / list2.get(i));
                System.out.println();
            }
            double d = Test06.computeChiSqr(series, series2, list, list2);
            System.out.print("chi^2 = ");
            System.out.print(d);
            System.out.println();
            int n3 = n - 2 * n2;
            System.out.print("dof   = ");
            System.out.print(n3);
            System.out.println();
            double d2 = Math.sqrt(d / (double)n3);
            System.out.print("sigma = ");
            System.out.print(d2);
            System.out.println();
        }
    }

    private static double computeChiSqr(Series series, Series series2, List<Double> list, List<Double> list2) {
        int n = series.length();
        int n2 = list.size();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = series.x(i);
            double d3 = 0.0;
            for (int j = 0; j < n2; ++j) {
                d3 += SpinSignal.S(list.get(j), list2.get(j), d2);
            }
            double d4 = d3 - series2.x(i);
            d += d4 * d4;
        }
        return d;
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.mri.test.Test06 <signalfile> <R1_lower> <R1_upper> <N> <index>");
        System.err.println("<signalfile> = Input spin signal data set file");
        System.err.println("<R1_lower> = Lower R1 spin-lattice relaxation rate (1/sec)");
        System.err.println("<R1_upper> = Upper R1 spin-lattice relaxation rate (1/sec)");
        System.err.println("<N> = Number of R1 intervals");
        System.err.println("<index> = Pixel index");
        System.exit(1);
    }
}

