/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.CharacterBuf;
import edu.rit.mp.buf.CharacterMatrixBuf;
import edu.rit.pj.reduction.CharacterOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

class CharacterMatrixReductionBuf
extends CharacterMatrixBuf {
    CharacterOp myOp;

    public CharacterMatrixReductionBuf(char[][] cArray, Range range, Range range2, CharacterOp characterOp) {
        super(cArray, range, range2);
        if (characterOp == null) {
            throw new NullPointerException("CharacterMatrixReductionBuf(): op is null");
        }
        this.myOp = characterOp;
    }

    public void put(int n, char c) {
        int n2 = n / this.myColCount * this.myRowStride + this.myLowerRow;
        int n3 = n % this.myColCount * this.myColStride + this.myLowerCol;
        this.myMatrix[n2][n3] = this.myOp.op(this.myMatrix[n2][n3], c);
    }

    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof CharacterMatrixBuf) {
                CharacterMatrixBuf characterMatrixBuf = (CharacterMatrixBuf)buf;
                ReduceArrays.reduce(characterMatrixBuf.myMatrix, characterMatrixBuf.myRowRange, characterMatrixBuf.myColRange, this.myMatrix, this.myRowRange, this.myColRange, this.myOp);
            } else {
                CharacterBuf.defaultCopy((CharacterBuf)buf, this);
            }
        }
    }

    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        CharBuffer charBuffer = byteBuffer.asCharBuffer();
        n2 = Math.min(n2, charBuffer.remaining());
        int n3 = 0;
        int n4 = this.i2r(n);
        int n5 = n4 * this.myRowStride + this.myLowerRow;
        int n6 = this.i2c(n);
        int n7 = n6 * this.myColStride + this.myLowerCol;
        int n8 = Math.min(this.myColCount - n6, n2);
        while (n4 < this.myRowCount && n8 > 0) {
            char[] cArray = this.myMatrix[n5];
            for (n6 = 0; n6 < n8; ++n6) {
                cArray[n7] = this.myOp.op(cArray[n7], charBuffer.get());
                n7 += this.myColStride;
            }
            n3 += n8;
            ++n4;
            n5 += this.myRowStride;
            n7 = this.myLowerCol;
            n8 = Math.min(this.myColCount, n2 -= n8);
        }
        byteBuffer.position(byteBuffer.position() + 2 * n3);
        return n3;
    }
}

