/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.EmptyFloatBuf;
import edu.rit.mp.buf.FloatArrayBuf;
import edu.rit.mp.buf.FloatArrayBuf_1;
import edu.rit.mp.buf.FloatItemBuf;
import edu.rit.mp.buf.FloatMatrixBuf;
import edu.rit.mp.buf.FloatMatrixBuf_1;
import edu.rit.mp.buf.SharedFloatArrayBuf;
import edu.rit.mp.buf.SharedFloatArrayBuf_1;
import edu.rit.mp.buf.SharedFloatBuf;
import edu.rit.pj.reduction.SharedFloat;
import edu.rit.pj.reduction.SharedFloatArray;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public abstract class FloatBuf
extends Buf {
    protected FloatBuf(int n) {
        super((byte)7, n);
    }

    public static FloatBuf emptyBuffer() {
        return new EmptyFloatBuf();
    }

    public static FloatItemBuf buffer() {
        return new FloatItemBuf();
    }

    public static FloatItemBuf buffer(float f) {
        return new FloatItemBuf(f);
    }

    public static FloatBuf buffer(float[] fArray) {
        if (fArray == null) {
            throw new NullPointerException("FloatBuf.buffer(): theArray is null");
        }
        int n = Arrays.length(fArray);
        return new FloatArrayBuf_1(fArray, new Range(0, n - 1));
    }

    public static FloatBuf sliceBuffer(float[] fArray, Range range) {
        if (fArray == null) {
            throw new NullPointerException("FloatBuf.sliceBuffer(): theArray is null");
        }
        int n = Arrays.length(fArray);
        if (0 > range.lb() || range.ub() >= n) {
            throw new IndexOutOfBoundsException("FloatBuf.sliceBuffer(): theArray index range = 0.." + (n - 1) + ", theRange = " + range);
        }
        if (range.stride() == 1) {
            return new FloatArrayBuf_1(fArray, range);
        }
        return new FloatArrayBuf(fArray, range);
    }

    public static FloatBuf[] sliceBuffers(float[] fArray, Range[] rangeArray) {
        int n = rangeArray.length;
        FloatBuf[] floatBufArray = new FloatBuf[n];
        for (int i = 0; i < n; ++i) {
            floatBufArray[i] = FloatBuf.sliceBuffer(fArray, rangeArray[i]);
        }
        return floatBufArray;
    }

    public static FloatBuf buffer(float[][] fArray) {
        if (fArray == null) {
            throw new NullPointerException("FloatBuf.buffer(): theMatrix is null");
        }
        int n = Arrays.rowLength(fArray);
        int n2 = Arrays.colLength(fArray, 0);
        return new FloatMatrixBuf_1(fArray, new Range(0, n - 1), new Range(0, n2 - 1));
    }

    public static FloatBuf rowSliceBuffer(float[][] fArray, Range range) {
        if (fArray == null) {
            throw new NullPointerException("FloatBuf.rowSliceBuffer(): theMatrix is null");
        }
        int n = Arrays.rowLength(fArray);
        if (0 > range.lb() || range.ub() >= n) {
            throw new IndexOutOfBoundsException("FloatBuf.rowSliceBuffer(): theMatrix row index range = 0.." + (n - 1) + ", theRowRange = " + range);
        }
        int n2 = Arrays.colLength(fArray, range.lb());
        if (range.stride() == 1) {
            return new FloatMatrixBuf_1(fArray, range, new Range(0, n2 - 1));
        }
        return new FloatMatrixBuf(fArray, range, new Range(0, n2 - 1));
    }

    public static FloatBuf[] rowSliceBuffers(float[][] fArray, Range[] rangeArray) {
        int n = rangeArray.length;
        FloatBuf[] floatBufArray = new FloatBuf[n];
        for (int i = 0; i < n; ++i) {
            floatBufArray[i] = FloatBuf.rowSliceBuffer(fArray, rangeArray[i]);
        }
        return floatBufArray;
    }

    public static FloatBuf colSliceBuffer(float[][] fArray, Range range) {
        if (fArray == null) {
            throw new NullPointerException("FloatBuf.colSliceBuffer(): theMatrix is null");
        }
        int n = Arrays.rowLength(fArray);
        int n2 = Arrays.colLength(fArray, 0);
        if (0 > range.lb() || range.ub() >= n2) {
            throw new IndexOutOfBoundsException("FloatBuf.colSliceBuffer(): theMatrix column index range = 0.." + (n2 - 1) + ", theColRange = " + range);
        }
        if (range.stride() == 1) {
            return new FloatMatrixBuf_1(fArray, new Range(0, n - 1), range);
        }
        return new FloatMatrixBuf(fArray, new Range(0, n - 1), range);
    }

    public static FloatBuf[] colSliceBuffers(float[][] fArray, Range[] rangeArray) {
        int n = rangeArray.length;
        FloatBuf[] floatBufArray = new FloatBuf[n];
        for (int i = 0; i < n; ++i) {
            floatBufArray[i] = FloatBuf.colSliceBuffer(fArray, rangeArray[i]);
        }
        return floatBufArray;
    }

    public static FloatBuf patchBuffer(float[][] fArray, Range range, Range range2) {
        if (fArray == null) {
            throw new NullPointerException("FloatBuf.patchBuffer(): theMatrix is null");
        }
        int n = Arrays.rowLength(fArray);
        if (0 > range.lb() || range.ub() >= n) {
            throw new IndexOutOfBoundsException("FloatBuf.patchBuffer(): theMatrix row index range = 0.." + (n - 1) + ", theRowRange = " + range);
        }
        int n2 = Arrays.colLength(fArray, range.lb());
        if (0 > range2.lb() || range2.ub() >= n2) {
            throw new IndexOutOfBoundsException("FloatBuf.patchBuffer(): theMatrix column index range = 0.." + (n2 - 1) + ", theColRange = " + range2);
        }
        if (range.stride() == 1 && range2.stride() == 1) {
            return new FloatMatrixBuf_1(fArray, range, range2);
        }
        return new FloatMatrixBuf(fArray, range, range2);
    }

    public static FloatBuf[] patchBuffers(float[][] fArray, Range[] rangeArray, Range[] rangeArray2) {
        int n = rangeArray.length;
        int n2 = rangeArray2.length;
        FloatBuf[] floatBufArray = new FloatBuf[n * n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            Range range = rangeArray[i];
            for (int j = 0; j < n2; ++j) {
                floatBufArray[n3++] = FloatBuf.patchBuffer(fArray, range, rangeArray2[j]);
            }
        }
        return floatBufArray;
    }

    public static FloatBuf buffer(SharedFloat sharedFloat) {
        if (sharedFloat == null) {
            throw new NullPointerException("FloatBuf.buffer(): item is null");
        }
        return new SharedFloatBuf(sharedFloat);
    }

    public static FloatBuf buffer(SharedFloatArray sharedFloatArray) {
        if (sharedFloatArray == null) {
            throw new NullPointerException("FloatBuf.buffer(): theArray is null");
        }
        int n = sharedFloatArray.length();
        return new SharedFloatArrayBuf_1(sharedFloatArray, new Range(0, n - 1));
    }

    public static FloatBuf sliceBuffer(SharedFloatArray sharedFloatArray, Range range) {
        if (sharedFloatArray == null) {
            throw new NullPointerException("FloatBuf.sliceBuffer(): theArray is null");
        }
        int n = sharedFloatArray.length();
        if (0 > range.lb() || range.ub() >= n) {
            throw new IndexOutOfBoundsException("FloatBuf.sliceBuffer(): theArray index range = 0.." + (n - 1) + ", theRange = " + range);
        }
        if (range.stride() == 1) {
            return new SharedFloatArrayBuf_1(sharedFloatArray, range);
        }
        return new SharedFloatArrayBuf(sharedFloatArray, range);
    }

    public static FloatBuf[] sliceBuffers(SharedFloatArray sharedFloatArray, Range[] rangeArray) {
        int n = rangeArray.length;
        FloatBuf[] floatBufArray = new FloatBuf[n];
        for (int i = 0; i < n; ++i) {
            floatBufArray[i] = FloatBuf.sliceBuffer(sharedFloatArray, rangeArray[i]);
        }
        return floatBufArray;
    }

    public abstract float get(int var1);

    public abstract void put(int var1, float var2);

    public void copy(Buf buf) {
        if (buf != this) {
            FloatBuf.defaultCopy((FloatBuf)buf, this);
        }
    }

    public void fill(Object object) {
        float f = object == null ? 0.0f : ((Float)object).floatValue();
        for (int i = 0; i < this.myLength; ++i) {
            this.put(i, f);
        }
    }

    public Buf getTemporaryBuf() {
        return FloatBuf.buffer(new float[this.myLength]);
    }

    int skipItems(int n, ByteBuffer byteBuffer) {
        int n2 = Math.min(n, byteBuffer.remaining() / 4);
        byteBuffer.position(byteBuffer.position() + 4 * n2);
        return n2;
    }

    protected static void defaultCopy(FloatBuf floatBuf, FloatBuf floatBuf2) {
        int n = Math.min(floatBuf.myLength, floatBuf2.myLength);
        for (int i = 0; i < n; ++i) {
            floatBuf2.put(i, floatBuf.get(i));
        }
    }
}

