/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.image.test;

import edu.rit.color.HSB;
import edu.rit.image.PJGColorImage;
import edu.rit.image.PJGImage;
import edu.rit.util.Hex;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class Test01 {
    static int width;
    static int height;
    static double xcenter;
    static double ycenter;
    static double resolution;
    static int maxiter;
    static double gamma;
    static File filename;
    static int xoffset;
    static int yoffset;
    static int[][] matrix;
    static int[][] matrix2;
    static int[] huetable;

    private Test01() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        if (stringArray.length != 2) {
            Test01.usage();
        }
        height = width = Integer.parseInt(stringArray[0]);
        xcenter = -0.75;
        ycenter = 0.0;
        resolution = (double)width * 0.375;
        maxiter = 1000;
        gamma = 0.4;
        filename = new File(stringArray[1]);
        xoffset = -(width - 1) / 2;
        yoffset = (height - 1) / 2;
        matrix = new int[height][width];
        huetable = new int[maxiter + 1];
        for (int i = 0; i < maxiter; ++i) {
            Test01.huetable[i] = HSB.pack((float)Math.pow((double)i / (double)maxiter, gamma), 1.0f, 1.0f);
        }
        Test01.huetable[Test01.maxiter] = HSB.pack(1.0f, 1.0f, 0.0f);
        long l2 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec -- Calculating image");
        for (int i = 0; i < height; ++i) {
            int[] nArray = matrix[i];
            double d = ycenter + (double)(yoffset - i) / resolution;
            for (int j = 0; j < width; ++j) {
                int n;
                double d2 = xcenter + (double)(xoffset + j) / resolution;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                for (n = 0; n < maxiter && d7 <= 4.0; ++n) {
                    d5 = d3 * d3 - d4 * d4 + d2;
                    d6 = 2.0 * d3 * d4 + d;
                    d7 = d5 * d5 + d6 * d6;
                    d3 = d5;
                    d4 = d6;
                }
                nArray[j] = huetable[n];
            }
        }
        long l3 = System.currentTimeMillis();
        System.out.println(l3 - l + " msec -- Writing PJG file");
        PJGColorImage pJGColorImage = new PJGColorImage(height, width, matrix);
        PJGImage.Writer writer = pJGColorImage.prepareToWrite(new BufferedOutputStream(new FileOutputStream(filename)));
        writer.write();
        writer.close();
        long l4 = System.currentTimeMillis();
        System.out.println(l4 - l + " msec -- Reading PJG file");
        PJGColorImage pJGColorImage2 = new PJGColorImage();
        PJGImage.Reader reader = pJGColorImage2.prepareToRead(new BufferedInputStream(new FileInputStream(filename)));
        reader.read();
        reader.close();
        long l5 = System.currentTimeMillis();
        System.out.println(l5 - l + " msec -- Comparing images");
        matrix2 = pJGColorImage2.getMatrix();
        for (int i = 0; i < width; ++i) {
            int[] nArray = matrix[i];
            int[] nArray2 = matrix2[i];
            for (int j = 0; j < width; ++j) {
                if (nArray[j] == nArray2[j]) continue;
                System.out.print("matrix[");
                System.out.print(i);
                System.out.print("][");
                System.out.print(j);
                System.out.print("] = ");
                System.out.print(Hex.toString(nArray[j]));
                System.out.print(", matrix2[");
                System.out.print(i);
                System.out.print("][");
                System.out.print(j);
                System.out.print("] = ");
                System.out.print(Hex.toString(nArray2[j]));
                System.out.println();
            }
        }
        long l6 = System.currentTimeMillis();
        System.out.println(l6 - l + " msec -- Done");
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.image.test.Test01 <width> <filename>");
        System.err.println("<width> = Image width and height (pixels)");
        System.err.println("<filename> = PNG image file name");
        System.exit(1);
    }
}

