/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.image;

import edu.rit.image.PJGColorImage;
import edu.rit.image.PJGGrayImage;
import edu.rit.image.PJGHueImage;
import edu.rit.image.PJGImageFileFormatException;
import edu.rit.swing.Displayable;
import edu.rit.util.Range;
import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PJGImage {
    static final byte[] HEADER = new byte[]{0, 80, 74, 71, 0, 0, 0, 1};
    static final int SEGMENT_HEADER = 0;
    static final int SEGMENT_IMAGE_TYPE = 1;
    static final int SEGMENT_HEIGHT = 2;
    static final int SEGMENT_WIDTH = 3;
    static final int SEGMENT_CREATION_TIME = 4;
    static final int SEGMENT_COMMENT = 5;
    static final int SEGMENT_PIXEL_DATA_RLE_24_BIT_COLOR = 6;
    static final int SEGMENT_PIXEL_DATA_HDE_8_BIT_GRAY = 7;
    static final int SEGMENT_PIXEL_DATA_HDE_24_BIT_HUE = 8;
    static final int IMAGE_TYPE_24_BIT_COLOR = 0;
    static final int IMAGE_TYPE_8_BIT_GRAY = 1;
    static final int IMAGE_TYPE_24_BIT_HUE = 2;
    int myImageType;
    int myHeight;
    int myWidth;
    Long myCreationTime;
    LinkedList<String> myComments = new LinkedList();

    PJGImage(int n) {
        this.myImageType = n;
    }

    public int getHeight() {
        return this.myHeight;
    }

    public int getWidth() {
        return this.myWidth;
    }

    public Long getCreationTime() {
        return this.myCreationTime;
    }

    public void setCreationTime(Long l) {
        this.myCreationTime = l;
    }

    public Iterable<String> getComments() {
        return Collections.unmodifiableList(this.myComments);
    }

    public void clearComments() {
        this.myComments.clear();
    }

    public void addComment(String string) {
        this.myComments.add(string);
    }

    public abstract Writer prepareToWrite(OutputStream var1) throws IOException;

    public abstract Reader prepareToRead(InputStream var1) throws IOException;

    public static PJGImage createFromStream(InputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            throw new IOException("PJGImage.createImage(): Input stream does not support mark() and reset()");
        }
        inputStream.mark(100);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[HEADER.length];
        dataInputStream.readFully(byArray);
        if (!Arrays.equals(byArray, HEADER)) {
            throw new PJGImageFileFormatException("Invalid PJG header");
        }
        int n = -1;
        while (n == -1) {
            int n2 = dataInputStream.readUnsignedByte();
            switch (n2) {
                case 1: {
                    n = dataInputStream.readUnsignedByte();
                    break;
                }
                case 2: {
                    dataInputStream.readInt();
                    break;
                }
                case 3: {
                    dataInputStream.readInt();
                    break;
                }
                case 4: {
                    dataInputStream.readLong();
                    break;
                }
                case 5: {
                    dataInputStream.readUTF();
                }
            }
        }
        inputStream.reset();
        switch (n) {
            case 0: {
                return new PJGColorImage();
            }
            case 1: {
                return new PJGGrayImage();
            }
            case 2: {
                return new PJGHueImage();
            }
        }
        throw new PJGImageFileFormatException("Invalid PJG image type (= " + n + ")");
    }

    public static PJGImage readFromStream(InputStream inputStream) throws IOException {
        PJGImage pJGImage = PJGImage.createFromStream(inputStream);
        Reader reader = pJGImage.prepareToRead(inputStream);
        reader.read();
        reader.close();
        return pJGImage;
    }

    public abstract BufferedImage getBufferedImage();

    public abstract Displayable getDisplayable();

    void setHeightAndWidth(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("PJGImage.setHeightAndWidth(): theHeight = " + n + " illegal");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("PJGImage.setHeightAndWidth(): theWidth = " + n2 + " illegal");
        }
        this.myHeight = n;
        this.myWidth = n2;
    }

    void writeHeader(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(HEADER);
        dataOutputStream.writeByte(1);
        dataOutputStream.writeByte(this.myImageType);
        dataOutputStream.writeByte(2);
        dataOutputStream.writeInt(this.myHeight);
        dataOutputStream.writeByte(3);
        dataOutputStream.writeInt(this.myWidth);
        if (this.myCreationTime != null) {
            dataOutputStream.writeByte(4);
            dataOutputStream.writeLong(this.myCreationTime);
        }
        for (String string : this.myComments) {
            dataOutputStream.writeByte(5);
            dataOutputStream.writeUTF(string);
        }
    }

    int readHeader(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[HEADER.length];
        dataInputStream.readFully(byArray);
        if (!Arrays.equals(byArray, HEADER)) {
            throw new PJGImageFileFormatException("Invalid PJG header");
        }
        return dataInputStream.read();
    }

    int readImageType(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedByte();
        if (n != this.myImageType) {
            throw new PJGImageFileFormatException("Invalid PJG image type: required = " + this.myImageType + ", found = " + n);
        }
        return dataInputStream.read();
    }

    int readHeight(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n <= 0) {
            throw new PJGImageFileFormatException("Invalid PJG image height (= " + n + ")");
        }
        if (this.myHeight == 0) {
            this.myHeight = n;
        } else if (n != this.myHeight) {
            throw new PJGImageFileFormatException("Invalid PJG image height: required = " + this.myHeight + ", found = " + n);
        }
        return dataInputStream.read();
    }

    int readWidth(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n <= 0) {
            throw new PJGImageFileFormatException("Invalid PJG image width (= " + n + ")");
        }
        if (this.myWidth == 0) {
            this.myWidth = n;
        } else if (n != this.myWidth) {
            throw new PJGImageFileFormatException("Invalid PJG image width: required = " + this.myWidth + ", found = " + n);
        }
        return dataInputStream.read();
    }

    int readCreationTime(DataInputStream dataInputStream) throws IOException {
        this.myCreationTime = dataInputStream.readLong();
        return dataInputStream.read();
    }

    int readComment(DataInputStream dataInputStream) throws IOException {
        this.myComments.add(dataInputStream.readUTF());
        return dataInputStream.read();
    }

    public abstract class Reader {
        InputStream myIs;
        DataInputStream myDis;
        int myNextSegmentType;

        Reader(InputStream inputStream) throws IOException {
            if (inputStream == null) {
                throw new NullPointerException("PJGImage.Reader(): theStream is null");
            }
            this.myIs = inputStream;
            this.myDis = new DataInputStream(inputStream);
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            this.myNextSegmentType = PJGImage.this.readHeader(this.myDis);
            block7: while (true) {
                switch (this.myNextSegmentType) {
                    case 1: {
                        if (bl) {
                            throw new PJGImageFileFormatException("Invalid PJG file: multiple image type segments");
                        }
                        this.myNextSegmentType = PJGImage.this.readImageType(this.myDis);
                        bl = true;
                        continue block7;
                    }
                    case 2: {
                        if (bl2) {
                            throw new PJGImageFileFormatException("Invalid PJG file: multiple height segments");
                        }
                        this.myNextSegmentType = PJGImage.this.readHeight(this.myDis);
                        bl2 = true;
                        continue block7;
                    }
                    case 3: {
                        if (bl3) {
                            throw new PJGImageFileFormatException("Invalid PJG file: multiple width segments");
                        }
                        this.myNextSegmentType = PJGImage.this.readWidth(this.myDis);
                        bl3 = true;
                        continue block7;
                    }
                    case 4: {
                        if (bl4) {
                            throw new PJGImageFileFormatException("Invalid PJG file: multiple creation time segments");
                        }
                        this.myNextSegmentType = PJGImage.this.readCreationTime(this.myDis);
                        bl4 = true;
                        continue block7;
                    }
                    case 5: {
                        this.myNextSegmentType = PJGImage.this.readComment(this.myDis);
                        continue block7;
                    }
                }
                break;
            }
            if (!bl) {
                throw new PJGImageFileFormatException("Invalid PJG file: missing image type segment");
            }
            if (!bl2) {
                throw new PJGImageFileFormatException("Invalid PJG file: missing height segment");
            }
            if (!bl3) {
                throw new PJGImageFileFormatException("Invalid PJG file: missing width segment");
            }
        }

        public abstract void read() throws IOException;

        public abstract Range getRowRange() throws IOException;

        public abstract Range getColRange() throws IOException;

        public abstract void readSegment() throws IOException;

        public void close() throws IOException {
            this.myDis.close();
        }
    }

    public abstract class Writer {
        OutputStream myOs;
        DataOutputStream myDos;

        Writer(OutputStream outputStream) throws IOException {
            if (outputStream == null) {
                throw new NullPointerException("PJGImage.Writer(): theStream is null");
            }
            this.myOs = outputStream;
            this.myDos = new DataOutputStream(outputStream);
            PJGImage.this.writeHeader(this.myDos);
        }

        public abstract void write() throws IOException;

        public abstract void writeRowSlice(Range var1) throws IOException;

        public abstract void writeColSlice(Range var1) throws IOException;

        public abstract void writePatch(Range var1, Range var2) throws IOException;

        public void close() throws IOException {
            this.myDos.close();
        }
    }
}

