/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.draw.item;

import edu.rit.draw.Drawing;
import edu.rit.draw.item.Fill;
import edu.rit.draw.item.Outline;
import edu.rit.draw.item.Point;
import edu.rit.draw.item.RectangularItem;
import edu.rit.draw.item.Size;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;

public class Ellipse
extends RectangularItem {
    public static final double NORMAL_WIDTH = 72.0;
    public static final double NORMAL_HEIGHT = 72.0;
    private static final long serialVersionUID = 8085149752960383250L;
    private static double theDefaultWidth = 72.0;
    private static double theDefaultHeight = 72.0;

    public Ellipse() {
        this.width = theDefaultWidth;
        this.height = theDefaultHeight;
    }

    public Ellipse(Ellipse ellipse) {
        super(ellipse);
    }

    public static Size defaultSize() {
        return new Size(theDefaultWidth, theDefaultHeight);
    }

    public static void defaultSize(Size size) {
        if (size.width < 0.0 || size.height < 0.0) {
            throw new IllegalArgumentException();
        }
        theDefaultWidth = size.width;
        theDefaultHeight = size.height;
    }

    public static double defaultWidth() {
        return theDefaultWidth;
    }

    public static void defaultWidth(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        theDefaultWidth = d;
    }

    public static double defaultHeight() {
        return theDefaultHeight;
    }

    public static void defaultHeight(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        theDefaultHeight = d;
    }

    public Ellipse outline(Outline outline) {
        this.doOutline(outline);
        return this;
    }

    public Ellipse fill(Fill fill) {
        this.doFill(fill);
        return this;
    }

    public Ellipse size(Size size) {
        this.doSize(size);
        return this;
    }

    public Ellipse width(double d) {
        this.doWidth(d);
        return this;
    }

    public Ellipse height(double d) {
        this.doHeight(d);
        return this;
    }

    public Ellipse diameter(double d) {
        this.doWidth(d);
        this.doHeight(d);
        return this;
    }

    public Ellipse nw(double d, double d2) {
        this.doNw(d, d2);
        return this;
    }

    public Ellipse nw(Point point) {
        this.doNw(point.x, point.y);
        return this;
    }

    public Ellipse n(double d, double d2) {
        this.doN(d, d2);
        return this;
    }

    public Ellipse n(Point point) {
        this.doN(point.x, point.y);
        return this;
    }

    public Ellipse ne(double d, double d2) {
        this.doNe(d, d2);
        return this;
    }

    public Ellipse ne(Point point) {
        this.doNe(point.x, point.y);
        return this;
    }

    public Ellipse w(double d, double d2) {
        this.doW(d, d2);
        return this;
    }

    public Ellipse w(Point point) {
        this.doW(point.x, point.y);
        return this;
    }

    public Ellipse c(double d, double d2) {
        this.doC(d, d2);
        return this;
    }

    public Ellipse c(Point point) {
        this.doC(point.x, point.y);
        return this;
    }

    public Ellipse e(double d, double d2) {
        this.doE(d, d2);
        return this;
    }

    public Ellipse e(Point point) {
        this.doE(point.x, point.y);
        return this;
    }

    public Ellipse sw(double d, double d2) {
        this.doSw(d, d2);
        return this;
    }

    public Ellipse sw(Point point) {
        this.doSw(point.x, point.y);
        return this;
    }

    public Ellipse s(double d, double d2) {
        this.doS(d, d2);
        return this;
    }

    public Ellipse s(Point point) {
        this.doS(point.x, point.y);
        return this;
    }

    public Ellipse se(double d, double d2) {
        this.doSe(d, d2);
        return this;
    }

    public Ellipse se(Point point) {
        this.doSe(point.x, point.y);
        return this;
    }

    public Ellipse add() {
        this.doAdd(Drawing.defaultDrawing());
        return this;
    }

    public Ellipse add(Drawing drawing) {
        this.doAdd(drawing);
        return this;
    }

    public Ellipse addFirst() {
        this.doAddFirst(Drawing.defaultDrawing());
        return this;
    }

    public Ellipse addFirst(Drawing drawing) {
        this.doAddFirst(drawing);
        return this;
    }

    public Point circumferencePoint(double d) {
        Point point = this.c();
        double d2 = point.x;
        double d3 = point.y;
        double d4 = this.width() / 2.0;
        double d5 = this.height() / 2.0;
        double d6 = d2 + d4 * Math.cos(d);
        double d7 = d3 + d5 * Math.sin(d);
        return new Point(d6, d7);
    }

    public Point circumferencePointDegrees(double d) {
        return this.circumferencePoint(d / 180.0 * Math.PI);
    }

    public Point circumferencePoint(double d, double d2) {
        Point point = this.c();
        double d3 = point.x;
        double d4 = point.y;
        double d5 = this.width() / 2.0;
        double d6 = this.height() / 2.0;
        double d7 = d5 * Math.cos(d);
        double d8 = d6 * Math.sin(d);
        double d9 = Math.sqrt(d7 * d7 + d8 * d8);
        double d10 = d3 + d7 + d7 / d9 * d2;
        double d11 = d4 + d8 + d8 / d9 * d2;
        return new Point(d10, d11);
    }

    public Point circumferencePointDegrees(double d, double d2) {
        return this.circumferencePoint(d / 180.0 * Math.PI, d2);
    }

    public Point perimeterIntersection(Point point) {
        return this.perimeterIntersection(point.x, point.y);
    }

    public Point perimeterIntersection(double d, double d2) {
        Point point = this.c();
        double d3 = point.x;
        double d4 = point.y;
        double d5 = this.width() / 2.0;
        double d6 = this.height() / 2.0;
        double d7 = d - d3;
        double d8 = d2 - d4;
        double d9 = Math.sqrt(d7 * d7 + d8 * d8);
        return new Point(d3 + d5 * d7 / d9, d4 + d6 * d8 / d9);
    }

    Shape getShape() {
        Point point = this.nw();
        return new Ellipse2D.Double(point.x, point.y, this.width, this.height);
    }
}

