/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.draw.item;

import edu.rit.draw.Drawing;
import edu.rit.draw.item.Point;
import edu.rit.draw.item.Size;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class DrawingItem
implements Externalizable {
    private static final long serialVersionUID = -7001285340255383829L;

    public DrawingItem() {
    }

    public DrawingItem(DrawingItem drawingItem) {
    }

    public Size size() {
        return new Size(this.width(), this.height());
    }

    public abstract double width();

    public abstract double height();

    public abstract Point nw();

    public Point n() {
        return this.nw().add(0.5 * this.width(), 0.0);
    }

    public Point ne() {
        return this.nw().add(this.width(), 0.0);
    }

    public Point w() {
        return this.nw().add(0.0, 0.5 * this.height());
    }

    public Point c() {
        return this.nw().add(0.5 * this.width(), 0.5 * this.height());
    }

    public Point e() {
        return this.nw().add(this.width(), 0.5 * this.height());
    }

    public Point sw() {
        return this.nw().add(0.0, this.height());
    }

    public Point s() {
        return this.nw().add(0.5 * this.width(), this.height());
    }

    public Point se() {
        return this.nw().add(this.width(), this.height());
    }

    public DrawingItem add() {
        this.doAdd(Drawing.defaultDrawing());
        return this;
    }

    public DrawingItem add(Drawing drawing) {
        this.doAdd(drawing);
        return this;
    }

    public DrawingItem addFirst() {
        this.doAddFirst(Drawing.defaultDrawing());
        return this;
    }

    public DrawingItem addFirst(Drawing drawing) {
        this.doAddFirst(drawing);
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
    }

    public void draw(Graphics2D graphics2D) {
    }

    public Rectangle2D boundingBox() {
        Point point = this.nw();
        return new Rectangle2D.Double(point.x, point.y, this.width(), this.height());
    }

    void doAdd(Drawing drawing) {
        drawing.add(this);
    }

    void doAddFirst(Drawing drawing) {
        drawing.addFirst(this);
    }
}

