/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.draw.item;

import edu.rit.draw.item.ColorFill;
import edu.rit.draw.item.Fill;
import edu.rit.draw.item.Outline;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class DashedOutline
implements Outline {
    public static final float NORMAL_WIDTH = 1.0f;
    public static final Fill NORMAL_FILL = ColorFill.BLACK;
    public static final float NORMAL_DOWN_FACTOR = 10.0f;
    public static final float NORMAL_UP_FACTOR = 6.0f;
    public static final DashedOutline NORMAL_OUTLINE = new DashedOutline();
    private static final long serialVersionUID = 8450835114943482027L;
    private float myWidth;
    private Fill myFill;
    private float myDownFactor;
    private float myUpFactor;
    private transient BasicStroke myStroke;

    public DashedOutline() {
        this.myWidth = 1.0f;
        this.myFill = NORMAL_FILL;
        this.myDownFactor = 10.0f;
        this.myUpFactor = 6.0f;
        this.computeStroke();
    }

    public DashedOutline(DashedOutline dashedOutline) {
        this.myWidth = dashedOutline.myWidth;
        this.myFill = dashedOutline.myFill;
        this.myDownFactor = dashedOutline.myDownFactor;
        this.myUpFactor = dashedOutline.myUpFactor;
        this.computeStroke();
    }

    public float width() {
        return this.myWidth;
    }

    public DashedOutline width(float f) {
        if ((double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.myWidth = f;
        this.computeStroke();
        return this;
    }

    public Fill fill() {
        return this.myFill;
    }

    public DashedOutline fill(Fill fill) {
        if (fill == null) {
            throw new NullPointerException();
        }
        this.myFill = fill;
        this.computeStroke();
        return this;
    }

    public float down() {
        return this.myDownFactor;
    }

    public DashedOutline down(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException();
        }
        this.myDownFactor = f;
        this.computeStroke();
        return this;
    }

    public float up() {
        return this.myUpFactor;
    }

    public DashedOutline up(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException();
        }
        this.myUpFactor = f;
        this.computeStroke();
        return this;
    }

    public float getStrokeWidth() {
        return this.myWidth;
    }

    public void setGraphicsContext(Graphics2D graphics2D) {
        graphics2D.setStroke(this.myStroke);
        this.myFill.setGraphicsContext(graphics2D);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeFloat(this.myWidth);
        objectOutput.writeFloat(this.myDownFactor);
        objectOutput.writeFloat(this.myUpFactor);
        objectOutput.writeObject(this.myFill);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.myWidth = objectInput.readFloat();
        this.myDownFactor = objectInput.readFloat();
        this.myUpFactor = objectInput.readFloat();
        this.myFill = (Fill)objectInput.readObject();
        this.computeStroke();
    }

    private void computeStroke() {
        this.myStroke = new BasicStroke(this.myWidth, 2, 0, 10.0f, new float[]{this.myDownFactor * this.myWidth, this.myUpFactor * this.myWidth}, 0.0f);
    }
}

