/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.draw.item;

import edu.rit.draw.item.Fill;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ColorFill
implements Fill {
    public static final ColorFill WHITE = new ColorFill();
    public static final ColorFill LIGHT_GRAY = new ColorFill().color(Color.LIGHT_GRAY);
    public static final ColorFill GRAY = new ColorFill().color(Color.GRAY);
    public static final ColorFill DARK_GRAY = new ColorFill().color(Color.DARK_GRAY);
    public static final ColorFill BLACK = new ColorFill().color(Color.BLACK);
    public static final ColorFill RED = new ColorFill().color(Color.RED);
    public static final ColorFill PINK = new ColorFill().color(Color.PINK);
    public static final ColorFill ORANGE = new ColorFill().color(Color.ORANGE);
    public static final ColorFill YELLOW = new ColorFill().color(Color.YELLOW);
    public static final ColorFill GREEN = new ColorFill().color(Color.GREEN);
    public static final ColorFill MAGENTA = new ColorFill().color(Color.MAGENTA);
    public static final ColorFill CYAN = new ColorFill().color(Color.CYAN);
    public static final ColorFill BLUE = new ColorFill().color(Color.BLUE);
    public static final ColorFill NORMAL_FILL = WHITE;
    private static final long serialVersionUID = 1702092537732335278L;
    private transient Color myColor;

    public ColorFill() {
        this.myColor = Color.white;
    }

    public ColorFill(ColorFill colorFill) {
        this.myColor = colorFill.myColor;
    }

    public Color color() {
        return this.myColor;
    }

    public ColorFill gray(int n) {
        this.myColor = new Color(n, n, n);
        return this;
    }

    public ColorFill gray(float f) {
        this.myColor = new Color(f, f, f);
        return this;
    }

    public ColorFill rgb(int n, int n2, int n3) {
        this.myColor = new Color(n, n2, n3);
        return this;
    }

    public ColorFill rgb(float f, float f2, float f3) {
        this.myColor = new Color(f, f2, f3);
        return this;
    }

    public ColorFill color(Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        this.myColor = color;
        return this;
    }

    public void setGraphicsContext(Graphics2D graphics2D) {
        graphics2D.setPaint(this.myColor);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.myColor.getRGB());
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.myColor = new Color(objectInput.readInt(), true);
    }
}

