/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.timing;

import edu.rit.mp.DoubleBuf;
import edu.rit.pj.Comm;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;

public class TimeBcastDouble {
    private static final DecimalFormat FMT3 = new DecimalFormat("0.00E0");
    static Comm world;
    static int size;
    static int rank;
    static int reps;
    static int numn;
    static int[] n;

    private TimeBcastDouble() {
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        Comm.init(stringArray);
        world = Comm.world();
        size = world.size();
        rank = world.rank();
        if (stringArray.length < 2) {
            TimeBcastDouble.usage();
        }
        reps = Integer.parseInt(stringArray[0]);
        numn = stringArray.length - 1;
        TimeBcastDouble.n = new int[numn];
        for (n = 0; n < numn; ++n) {
            TimeBcastDouble.n[n] = Integer.parseInt(stringArray[n + 1]);
        }
        if (rank == 0) {
            System.out.println("java -Dpj.np=" + size + " edu.rit.clu.timing.TimeBcastDouble " + reps);
            System.out.println(new Date());
            System.out.println("n\ttime1\ttime2\tBcast time (sec)");
        }
        for (n = 0; n < numn; ++n) {
            int n2 = TimeBcastDouble.n[n];
            double[] dArray = new double[n2];
            DoubleBuf doubleBuf = DoubleBuf.buffer(dArray);
            long l = -System.currentTimeMillis();
            for (int i = 0; i < reps; ++i) {
                TimeBcastDouble.fill(n2, dArray, doubleBuf);
            }
            l += System.currentTimeMillis();
            long l2 = -System.currentTimeMillis();
            for (int i = 0; i < reps; ++i) {
                TimeBcastDouble.fillBroadcast(n2, dArray, doubleBuf);
            }
            l2 += System.currentTimeMillis();
            if (rank != 0) continue;
            double d = (double)(l2 - l) / (double)reps / (double)size / 1000.0;
            System.out.print(n2);
            System.out.print('\t');
            System.out.print(l);
            System.out.print('\t');
            System.out.print(l2);
            System.out.print('\t');
            System.out.print(FMT3.format(d));
            System.out.println();
        }
    }

    private static void fill(int n, double[] dArray, DoubleBuf doubleBuf) {
        for (int i = 0; i < n; ++i) {
            dArray[i] = i;
        }
    }

    private static void fillBroadcast(int n, double[] dArray, DoubleBuf doubleBuf) throws IOException {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = n2;
        }
        for (n2 = size; n2 > 0; --n2) {
            world.broadcast(n2 % size, doubleBuf);
        }
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=<K> edu.rit.clu.timing.TimeBcastDouble <reps> <n1> [<n2> ...]");
        System.err.println("<K> = Number of processors, <K> >= 2");
        System.err.println("<reps> = Number of repetitions for each value of <n>");
        System.err.println("<n1> = First value of <n>");
        System.err.println("<n2> = Second value of <n> . . .");
        System.exit(1);
    }
}

