/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.heat;

import edu.rit.image.ColorImageRow;
import edu.rit.image.PJGHueImage;
import edu.rit.image.PJGImage;
import edu.rit.io.Files;
import edu.rit.mp.DoubleBuf;
import edu.rit.mp.buf.DoubleItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.reduction.DoubleOp;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;

public class HotSpotClu {
    private static final double MIN_TEMP = 0.0;
    private static final double MAX_TEMP = 100.0;
    private static final double DELTA_TEMP = 100.0;
    private static final double MIN_HUE = 0.6666666666666666;
    private static final double MAX_HUE = 0.0;
    private static final double DELTA_HUE = -0.6666666666666666;
    private static final double EPS = 0.001;
    private static final int FIRST = 0;
    private static final int MIDDLE = 1;
    private static final int LAST = 2;
    private static final int SINGLE = 3;
    static Comm world;
    static int size;
    static int rank;
    static int position;
    static int predRank;
    static int succRank;
    static File imagefile;
    static int H;
    static int W;
    static Range[] slices;
    static Range mySlice;
    static int myLb;
    static int myUb;
    static int myLen;
    static double[][] h;
    static boolean[][] hotspot;
    static double EPS_initialTotalAbsXi;
    static double totalAbsXi;
    static int MAXITER;
    static double rho_s_sqr;
    static double omega_over_4;
    static int iterations;
    static DoubleItemBuf xibuf;
    static DoubleBuf hbuf_pred_red;
    static DoubleBuf hbuf_pred_black;
    static DoubleBuf hbuf_top_red;
    static DoubleBuf hbuf_top_black;
    static DoubleBuf hbuf_bottom_red;
    static DoubleBuf hbuf_bottom_black;
    static DoubleBuf hbuf_succ_red;
    static DoubleBuf hbuf_succ_black;

    private HotSpotClu() {
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        int n;
        Object[] objectArray;
        int n2;
        int n3;
        long l = System.currentTimeMillis();
        Comm.init(stringArray);
        world = Comm.world();
        size = world.size();
        rank = world.rank();
        position = size == 1 ? 3 : (rank == 0 ? 0 : (rank < size - 1 ? 1 : 2));
        predRank = rank - 1;
        succRank = rank + 1;
        if (stringArray.length < 8 || stringArray.length % 5 != 3) {
            HotSpotClu.usage();
        }
        imagefile = new File(stringArray[0]);
        H = Integer.parseInt(stringArray[1]);
        W = Integer.parseInt(stringArray[2]);
        if (H < 1) {
            HotSpotClu.usage();
        }
        if (W < 1) {
            HotSpotClu.usage();
        }
        slices = new Range(1, H).subranges(size);
        mySlice = slices[rank];
        myLb = mySlice.lb();
        myUb = mySlice.ub();
        myLen = mySlice.length();
        h = new double[H + 2][];
        Arrays.allocate(h, new Range(myLb - 1, myUb + 1), W + 2);
        hotspot = new boolean[H + 2][];
        Arrays.allocate(hotspot, new Range(myLb - 1, myUb + 1), W + 2);
        int n4 = (stringArray.length - 3) / 5;
        for (int i = 0; i < n4; ++i) {
            int n5 = Integer.parseInt(stringArray[3 + 5 * i]);
            n3 = Integer.parseInt(stringArray[4 + 5 * i]);
            int n6 = Integer.parseInt(stringArray[5 + 5 * i]);
            int n7 = Integer.parseInt(stringArray[6 + 5 * i]);
            double d = Double.parseDouble(stringArray[7 + 5 * i]);
            if (1 > n5 || n5 > W) {
                HotSpotClu.usage();
            }
            if (1 > n3 || n3 > H) {
                HotSpotClu.usage();
            }
            if (1 > n6 || n6 > W) {
                HotSpotClu.usage();
            }
            if (1 > n7 || n7 > H) {
                HotSpotClu.usage();
            }
            if (0.0 > d || d > 100.0) {
                HotSpotClu.usage();
            }
            for (n2 = n5; n2 <= n6; ++n2) {
                objectArray = h[n2];
                boolean[] blArray = hotspot[n2];
                if (objectArray == null) continue;
                for (n = n3; n <= n7; ++n) {
                    objectArray[n] = d;
                    blArray[n] = true;
                }
            }
        }
        xibuf = DoubleBuf.buffer();
        hbuf_pred_red = HotSpotClu.redBuffer(myLb - 1);
        hbuf_pred_black = HotSpotClu.blackBuffer(myLb - 1);
        hbuf_top_red = HotSpotClu.redBuffer(myLb);
        hbuf_top_black = HotSpotClu.blackBuffer(myLb);
        hbuf_bottom_red = HotSpotClu.redBuffer(myUb);
        hbuf_bottom_black = HotSpotClu.blackBuffer(myUb);
        hbuf_succ_red = HotSpotClu.redBuffer(myUb + 1);
        hbuf_succ_black = HotSpotClu.blackBuffer(myUb + 1);
        totalAbsXi = 0.0;
        for (n3 = myLb; n3 <= myUb; ++n3) {
            double[] dArray = h[n3 - 1];
            double[] dArray2 = h[n3];
            double[] dArray3 = h[n3 + 1];
            object2 = hotspot[n3];
            for (n2 = 1; n2 <= W; ++n2) {
                double d = object2[n2] ? 0.0 : dArray[n2] + dArray3[n2] + dArray2[n2 - 1] + dArray2[n2 + 1] - 4.0 * dArray2[n2];
                totalAbsXi += Math.abs(d);
            }
        }
        HotSpotClu.xibuf.item = totalAbsXi;
        world.allReduce(xibuf, DoubleOp.SUM);
        totalAbsXi = HotSpotClu.xibuf.item;
        EPS_initialTotalAbsXi = 0.001 * totalAbsXi;
        MAXITER = 2 * (W + H);
        rho_s_sqr = 0.5 * (Math.cos(Math.PI / (double)W) + Math.cos(Math.PI / (double)H));
        rho_s_sqr *= rho_s_sqr;
        omega_over_4 = 0.25;
        iterations = 0;
        long l2 = System.currentTimeMillis();
        do {
            int n8;
            double[] dArray;
            double[] dArray4;
            int n9;
            totalAbsXi = 0.0;
            for (n9 = myLb; n9 <= myUb; ++n9) {
                dArray4 = h[n9 - 1];
                object2 = h[n9];
                dArray = h[n9 + 1];
                objectArray = hotspot[n9];
                for (n8 = 1 + (n9 & 1); n8 <= W; n8 += 2) {
                    double d = objectArray[n8] != false ? 0.0 : dArray4[n8] + dArray[n8] + object2[n8 - 1] + object2[n8 + 1] - 4.0 * object2[n8];
                    totalAbsXi += Math.abs(d);
                    int n10 = n8;
                    object2[n10] = object2[n10] + omega_over_4 * d;
                }
            }
            omega_over_4 = 0.25 / (1.0 - rho_s_sqr * (iterations == 0 ? 0.5 : omega_over_4));
            switch (position) {
                case 0: {
                    world.send(succRank, hbuf_bottom_red);
                    world.receive(succRank, hbuf_succ_red);
                    break;
                }
                case 1: {
                    world.sendReceive(succRank, hbuf_bottom_red, predRank, hbuf_pred_red);
                    world.sendReceive(predRank, hbuf_top_red, succRank, hbuf_succ_red);
                    break;
                }
                case 2: {
                    world.receive(predRank, hbuf_pred_red);
                    world.send(predRank, hbuf_top_red);
                }
            }
            for (n9 = myLb; n9 <= myUb; ++n9) {
                dArray4 = h[n9 - 1];
                object2 = h[n9];
                dArray = h[n9 + 1];
                objectArray = hotspot[n9];
                for (n8 = 2 - (n9 & 1); n8 <= W; n8 += 2) {
                    double d = objectArray[n8] != false ? 0.0 : dArray4[n8] + dArray[n8] + object2[n8 - 1] + object2[n8 + 1] - 4.0 * object2[n8];
                    totalAbsXi += Math.abs(d);
                    int n11 = n8;
                    object2[n11] = object2[n11] + omega_over_4 * d;
                }
            }
            omega_over_4 = 0.25 / (1.0 - rho_s_sqr * omega_over_4);
            switch (position) {
                case 0: {
                    world.send(succRank, hbuf_bottom_black);
                    world.receive(succRank, hbuf_succ_black);
                    break;
                }
                case 1: {
                    world.sendReceive(succRank, hbuf_bottom_black, predRank, hbuf_pred_black);
                    world.sendReceive(predRank, hbuf_top_black, succRank, hbuf_succ_black);
                    break;
                }
                case 2: {
                    world.receive(predRank, hbuf_pred_black);
                    world.send(predRank, hbuf_top_black);
                }
            }
            HotSpotClu.xibuf.item = totalAbsXi;
            world.allReduce(xibuf, DoubleOp.SUM);
            totalAbsXi = HotSpotClu.xibuf.item;
        } while (++iterations < MAXITER && totalAbsXi >= EPS_initialTotalAbsXi);
        if (iterations == MAXITER) {
            System.err.println("HotSpotClu: Did not converge");
            System.exit(1);
        }
        long l3 = System.currentTimeMillis();
        object2 = new int[H + 2][];
        int n12 = rank == 0 ? myLb - 1 : myLb;
        int n13 = rank == size - 1 ? myUb + 1 : myUb;
        Arrays.allocate((int[][])object2, new Range(n12, n13), W + 2);
        ColorImageRow colorImageRow = new ColorImageRow((int[])object2[n12]);
        for (n = n12; n <= n13; ++n) {
            object = h[n];
            colorImageRow.setArray((int[])object2[n]);
            for (int i = 0; i <= W + 1; ++i) {
                colorImageRow.setPixelHSB(i, (float)((object[i] - 0.0) / 100.0 * -0.6666666666666666 + 0.6666666666666666), 1.0f, 1.0f);
            }
        }
        PJGHueImage pJGHueImage = new PJGHueImage(H + 2, W + 2, (int[][])object2);
        object = pJGHueImage.prepareToWrite(new BufferedOutputStream(new FileOutputStream(Files.fileForRank(imagefile, rank))));
        ((PJGImage.Writer)object).writeRowSlice(new Range(n12, n13));
        ((PJGImage.Writer)object).close();
        long l4 = System.currentTimeMillis();
        System.out.println(iterations + " iterations " + rank);
        System.out.println(l2 - l + " msec pre " + rank);
        System.out.println(l3 - l2 + " msec calc " + rank);
        System.out.println(l4 - l3 + " msec post " + rank);
        System.out.println(l4 - l + " msec total " + rank);
    }

    private static DoubleBuf redBuffer(int n) {
        return DoubleBuf.sliceBuffer(h[n], new Range(1 + (n & 1), W, 2));
    }

    private static DoubleBuf blackBuffer(int n) {
        return DoubleBuf.sliceBuffer(h[n], new Range(2 - (n & 1), W, 2));
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=<K> edu.rit.clu.heat.HotSpotClu <imagefile> <H> <W> <rl1> <cl1> <ru1> <cu1> <temp1> [ <rl2> <cl2> <ru2> <cu2> <temp2> . . . ]");
        System.err.println("<K> = Number of parallel processes");
        System.err.println("<imagefile> = Output image file name");
        System.err.println("<H> = Mesh height in pixels (<H> >= 1)");
        System.err.println("<W> = Mesh width in pixels (<W> >= 1)");
        System.err.println("<rl1> = First hot spot lower row (1 <= <rl1> <= <W>)");
        System.err.println("<cl1> = First hot spot lower column (1 <= <cl1> <= <H>)");
        System.err.println("<ru1> = First hot spot upper row (1 <= <ru1> <= <W>)");
        System.err.println("<cu1> = First hot spot upper column (1 <= <cu1> <= <H>)");
        System.err.println("<temp1> = First hot spot temperature (0.0 <= <temp1> <= 100.0)");
        System.exit(1);
    }
}

