/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.fractal;

import edu.rit.color.HSB;
import edu.rit.image.PJGColorImage;
import edu.rit.image.PJGImage;
import edu.rit.mp.Buf;
import edu.rit.mp.IntegerBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.WorkerIntegerForLoop;
import edu.rit.pj.WorkerRegion;
import edu.rit.pj.WorkerTeam;
import edu.rit.util.Range;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class MandelbrotSetClu2 {
    static Comm world;
    static int size;
    static int rank;
    static int width;
    static int height;
    static double xcenter;
    static double ycenter;
    static double resolution;
    static int maxiter;
    static double gamma;
    static File filename;
    static int xoffset;
    static int yoffset;
    static int[][] matrix;
    static PJGColorImage image;
    static int[] huetable;
    static int chunkCount;

    private MandelbrotSetClu2() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        Comm.init(stringArray);
        world = Comm.world();
        size = world.size();
        rank = world.rank();
        if (stringArray.length != 8) {
            MandelbrotSetClu2.usage();
        }
        width = Integer.parseInt(stringArray[0]);
        height = Integer.parseInt(stringArray[1]);
        xcenter = Double.parseDouble(stringArray[2]);
        ycenter = Double.parseDouble(stringArray[3]);
        resolution = Double.parseDouble(stringArray[4]);
        maxiter = Integer.parseInt(stringArray[5]);
        gamma = Double.parseDouble(stringArray[6]);
        filename = new File(stringArray[7]);
        xoffset = -(width - 1) / 2;
        yoffset = (height - 1) / 2;
        if (rank == 0) {
            matrix = new int[height][width];
            image = new PJGColorImage(height, width, matrix);
        }
        huetable = new int[maxiter + 1];
        for (int i = 0; i < maxiter; ++i) {
            MandelbrotSetClu2.huetable[i] = HSB.pack((float)Math.pow((double)i / (double)maxiter, gamma), 1.0f, 1.0f);
        }
        MandelbrotSetClu2.huetable[MandelbrotSetClu2.maxiter] = HSB.pack(1.0f, 1.0f, 0.0f);
        long l2 = System.currentTimeMillis();
        new WorkerTeam().execute(new WorkerRegion(){

            public void run() throws Exception {
                this.execute(0, height - 1, new WorkerIntegerForLoop(){
                    int[][] slice = new int[0][];

                    public void run(int n, int n2) {
                        ++chunkCount;
                        int n3 = n2 - n + 1;
                        if (this.slice.length < n3) {
                            this.slice = new int[n3][width];
                        }
                        for (int i = n; i <= n2; ++i) {
                            int[] nArray = this.slice[i - n];
                            double d = ycenter + (double)(yoffset - i) / resolution;
                            for (int j = 0; j < width; ++j) {
                                int n4;
                                double d2 = xcenter + (double)(xoffset + j) / resolution;
                                double d3 = 0.0;
                                double d4 = 0.0;
                                double d5 = 0.0;
                                double d6 = 0.0;
                                double d7 = 0.0;
                                for (n4 = 0; n4 < maxiter && d7 <= 4.0; ++n4) {
                                    d5 = d3 * d3 - d4 * d4 + d2;
                                    d6 = 2.0 * d3 * d4 + d;
                                    d7 = d5 * d5 + d6 * d6;
                                    d3 = d5;
                                    d4 = d6;
                                }
                                nArray[j] = huetable[n4];
                            }
                        }
                    }

                    public void sendTaskOutput(Range range, Comm comm, int n, int n2) throws IOException {
                        comm.send(n, n2, IntegerBuf.rowSliceBuffer(this.slice, new Range(0, range.length() - 1)));
                    }

                    public void receiveTaskOutput(Range range, Comm comm, int n, int n2) throws IOException {
                        comm.receive((Integer)n, n2, (Buf)IntegerBuf.rowSliceBuffer(matrix, range));
                    }
                });
            }
        });
        long l3 = System.currentTimeMillis();
        if (rank == 0) {
            PJGImage.Writer writer = image.prepareToWrite(new BufferedOutputStream(new FileOutputStream(filename)));
            writer.write();
            writer.close();
        }
        long l4 = System.currentTimeMillis();
        System.out.println(chunkCount + " chunks " + rank);
        System.out.println(l2 - l + " msec pre " + rank);
        System.out.println(l3 - l2 + " msec calc " + rank);
        System.out.println(l4 - l3 + " msec post " + rank);
        System.out.println(l4 - l + " msec total " + rank);
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=<K> [-Dpj.schedule=<schedule>] edu.rit.clu.fractal.MandelbrotSetClu2 <width> <height> <xcenter> <ycenter> <resolution> <maxiter> <gamma> <filename>");
        System.err.println("<K> = Number of parallel processes");
        System.err.println("<schedule> = Load balancing schedule");
        System.err.println("<width> = Image width (pixels)");
        System.err.println("<height> = Image height (pixels)");
        System.err.println("<xcenter> = X coordinate of center point");
        System.err.println("<ycenter> = Y coordinate of center point");
        System.err.println("<resolution> = Pixels per unit");
        System.err.println("<maxiter> = Maximum number of iterations");
        System.err.println("<gamma> = Used to calculate pixel hues");
        System.err.println("<filename> = PJG image file name");
        System.exit(1);
    }
}

