/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.fractal;

import edu.rit.mp.IntegerBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.WorkerIntegerForLoop;
import edu.rit.pj.WorkerRegion;
import edu.rit.pj.WorkerTeam;
import edu.rit.pj.reduction.IntegerOp;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

public class MSHistogramClu {
    static Comm world;
    static int size;
    static int rank;
    static int width;
    static int height;
    static double xcenter;
    static double ycenter;
    static double resolution;
    static int maxiter;
    static File outfile;
    static int xoffset;
    static int yoffset;
    static int[] histogram;
    static final int HISTOGRAM_DATA_MSG = Integer.MAX_VALUE;
    static int chunkCount;

    private MSHistogramClu() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        Comm.init(stringArray);
        world = Comm.world();
        size = world.size();
        rank = world.rank();
        if (stringArray.length != 7) {
            MSHistogramClu.usage();
        }
        width = Integer.parseInt(stringArray[0]);
        height = Integer.parseInt(stringArray[1]);
        xcenter = Double.parseDouble(stringArray[2]);
        ycenter = Double.parseDouble(stringArray[3]);
        resolution = Double.parseDouble(stringArray[4]);
        maxiter = Integer.parseInt(stringArray[5]);
        outfile = new File(stringArray[6]);
        xoffset = -(width - 1) / 2;
        yoffset = (height - 1) / 2;
        histogram = new int[maxiter + 1];
        long l2 = System.currentTimeMillis();
        new WorkerTeam().execute(new WorkerRegion(){

            public void run() throws Exception {
                this.execute(0, height - 1, new WorkerIntegerForLoop(){

                    public void run(int n, int n2) throws Exception {
                        ++chunkCount;
                        for (int i = n; i <= n2; ++i) {
                            double d = ycenter + (double)(yoffset - i) / resolution;
                            for (int j = 0; j < width; ++j) {
                                int n3;
                                double d2 = xcenter + (double)(xoffset + j) / resolution;
                                double d3 = 0.0;
                                double d4 = 0.0;
                                double d5 = 0.0;
                                double d6 = 0.0;
                                double d7 = 0.0;
                                for (n3 = 0; n3 < maxiter && d7 <= 4.0; ++n3) {
                                    d5 = d3 * d3 - d4 * d4 + d2;
                                    d6 = 2.0 * d3 * d4 + d;
                                    d7 = d5 * d5 + d6 * d6;
                                    d3 = d5;
                                    d4 = d6;
                                }
                                int n4 = n3;
                                histogram[n4] = histogram[n4] + 1;
                            }
                        }
                    }
                });
            }
        });
        world.reduce(0, Integer.MAX_VALUE, IntegerBuf.buffer(histogram), IntegerOp.SUM);
        long l3 = System.currentTimeMillis();
        if (rank == 0) {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(outfile)));
            for (int i = 0; i <= maxiter; ++i) {
                printWriter.print(i);
                printWriter.print('\t');
                printWriter.print(histogram[i]);
                printWriter.println();
            }
            printWriter.close();
        }
        long l4 = System.currentTimeMillis();
        System.out.println(chunkCount + " chunks " + rank);
        System.out.println(l2 - l + " msec pre " + rank);
        System.out.println(l3 - l2 + " msec calc " + rank);
        System.out.println(l4 - l3 + " msec post " + rank);
        System.out.println(l4 - l + " msec total " + rank);
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=<K> [-Dpj.schedule=<schedule>] edu.rit.clu.fractal.MSHistogramClu <width> <height> <xcenter> <ycenter> <resolution> <maxiter> <outfile>");
        System.err.println("<K> = Number of parallel processes");
        System.err.println("<schedule> = Load balancing schedule");
        System.err.println("<width> = Image width (pixels)");
        System.err.println("<height> = Image height (pixels)");
        System.err.println("<xcenter> = X coordinate of center point");
        System.err.println("<ycenter> = Y coordinate of center point");
        System.err.println("<resolution> = Pixels per unit");
        System.err.println("<maxiter> = Maximum number of iterations");
        System.err.println("<outfile> = Output file name");
        System.exit(1);
    }
}

