/*
 * Decompiled with CFR 0.152.
 */
import edu.rit.numeric.ListXYSeries;
import edu.rit.numeric.plot.Dots;
import edu.rit.numeric.plot.Plot;
import java.awt.Color;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class HybridSpeedup {
    private static Pattern QUOTED_STRING_PATTERN = Pattern.compile("\"[^\"]*\"");
    private static DecimalFormat FMT_0 = new DecimalFormat("0");
    private static DecimalFormat FMT_0E = new DecimalFormat("0E0");
    private static DecimalFormat FMT_1 = new DecimalFormat("0.0");
    private static DecimalFormat FMT_2 = new DecimalFormat("0.00");
    private static DecimalFormat FMT_3 = new DecimalFormat("0.000");
    private static TreeMap<Integer, Data> dataMap = new TreeMap();
    private static TreeSet<Integer> Kp_set = new TreeSet();
    private static TreeSet<Integer> Kt_set = new TreeSet();
    private static double Kp_max = Double.NEGATIVE_INFINITY;
    private static double Kt_max = Double.NEGATIVE_INFINITY;
    private static Plot T_plot = new Plot();
    private static Plot Speedup_plot = new Plot();
    private static Plot Eff_plot = new Plot();
    private static Plot EDSF_plot = new Plot();

    private HybridSpeedup() {
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        if (stringArray.length != 1) {
            HybridSpeedup.usage();
        }
        File file = new File(stringArray[0]);
        T_plot.plotTitle("Running Time vs. Processors").rightMargin(54.0).minorGridLines(true).xAxisKind(Plot.LOGARITHMIC).xAxisMinorDivisions(10).xAxisTitle("Processes, <I>Kp</I>").yAxisKind(Plot.LOGARITHMIC).yAxisMinorDivisions(10).yAxisTickFormat(FMT_0E).yAxisTickScale(1000.0).yAxisTitle("<I>T</I> (<I>N,K</I>) (sec)").labelPosition(5).labelOffset(6.0);
        Speedup_plot.plotTitle("Speedup vs. Processors").rightMargin(54.0).xAxisStart(0.0).xAxisTitle("Processes, <I>Kp</I>").yAxisStart(0.0).yAxisTickFormat(FMT_0).yAxisTitle("<I>Speedup</I> (<I>N,K</I>)").labelPosition(5).labelOffset(6.0);
        Eff_plot.plotTitle("Efficiency vs. Processors").rightMargin(54.0).xAxisStart(0.0).xAxisTitle("Processes, <I>Kp</I>").yAxisStart(0.0).yAxisTickFormat(FMT_1).yAxisTitle("<I>Eff</I> (<I>N,K</I>)").labelPosition(5).labelOffset(6.0);
        EDSF_plot.plotTitle("EDSF vs. Processors").rightMargin(54.0).xAxisStart(0.0).xAxisTitle("Processes, <I>Kp</I>").yAxisStart(0.0).yAxisTickFormat(FMT_0).yAxisTickScale(0.001).yAxisTitle("<I>EDSF</I> (<I>N,K</I>) (/1000)").labelPosition(5).labelOffset(6.0);
        Scanner scanner = new Scanner(file);
        int n = 1;
        while (scanner.hasNextLine()) {
            object = scanner.nextLine();
            int n2 = ((String)object).indexOf(35);
            if (n2 >= 0) {
                object = ((String)object).substring(0, n2);
            }
            if (((String)(object = ((String)object).trim())).length() > 0) {
                HybridSpeedup.parseLine((String)object, n);
            }
            ++n;
        }
        for (Data data : dataMap.values()) {
            if (data.validate()) continue;
            HybridSpeedup.error("No data for n=" + data.n + ", Kp=1, Kt=1", n);
        }
        object = Kt_set.iterator();
        while (object.hasNext()) {
            int n3 = (Integer)object.next();
            Speedup_plot.seriesDots(null).seriesColor(new Color(0.7f, 0.7f, 0.7f)).xySeries(0.0, 0.0, Kp_max, Kp_max * (double)n3);
        }
        Eff_plot.seriesDots(null).seriesColor(new Color(0.7f, 0.7f, 0.7f)).xySeries(0.0, 1.0, Kp_max, 1.0);
        System.out.println("N\tKp\tKt\tT\tSpdup\tEffic\tEDSF\tDevi");
        for (Data data : dataMap.values()) {
            int n4;
            System.out.println();
            String string = data.labelText;
            if (string.startsWith("N = ")) {
                string = string.substring(4);
            } else if (string.startsWith("N=")) {
                string = string.substring(2);
            } else if (string.startsWith("<I>N</I> = ")) {
                string = string.substring(11);
            } else if (string.startsWith("<I>N</I>=")) {
                string = string.substring(9);
            }
            double d = 0.0;
            double d2 = 0.0;
            Collections.sort(data.entries);
            for (DataEntry dataEntry : data.entries) {
                double d3 = 100.0 * (dataEntry.T_max - dataEntry.T) / dataEntry.T;
                if (dataEntry.Kp == 0) {
                    d = dataEntry.T;
                    System.out.println(string + "\tseq\tseq\t" + FMT_0.format(dataEntry.T) + "\t\t\t\t" + FMT_0.format(d3) + "%");
                    continue;
                }
                if (dataEntry.Kp == 1 && dataEntry.Kt == 1) {
                    double d4;
                    if (d == 0.0) {
                        d = dataEntry.T;
                    }
                    d2 = dataEntry.T;
                    double d5 = d4 = d / dataEntry.T;
                    System.out.println(string + "\t1\t1\t" + FMT_0.format(dataEntry.T) + "\t" + FMT_3.format(d4) + "\t" + FMT_3.format(d5) + "\t\t" + FMT_0.format(d3) + "%");
                    continue;
                }
                int n5 = dataEntry.Kp * dataEntry.Kt;
                double d6 = d / dataEntry.T;
                double d7 = d6 / (double)n5;
                double d8 = (dataEntry.T * (double)n5 - d2) / d2 / (double)(n5 - 1);
                System.out.println(string + "\t" + dataEntry.Kp + "\t" + dataEntry.Kt + "\t" + FMT_0.format(dataEntry.T) + "\t" + FMT_3.format(d6) + "\t" + FMT_3.format(d7) + "\t" + FMT_3.format(d8) + "\t" + FMT_0.format(d3) + "%");
            }
            Iterator<Comparable<DataEntry>> iterator = Kt_set.iterator();
            while (iterator.hasNext()) {
                int n6 = (Integer)iterator.next();
                ListXYSeries listXYSeries = data.TVsKp(n6);
                n4 = listXYSeries.length();
                if (n4 > 0) {
                    T_plot.seriesDots(Dots.circle(5.0)).seriesColor(Color.black).xySeries(listXYSeries).label("<I>Kt</I> = " + n6, listXYSeries.x(n4 - 1), listXYSeries.y(n4 - 1));
                }
                if ((n4 = (listXYSeries = data.SpeedupVsKp(n6)).length()) > 0) {
                    Speedup_plot.seriesDots(Dots.circle(5.0)).seriesColor(Color.black).xySeries(listXYSeries).label("<I>Kt</I> = " + n6, listXYSeries.x(n4 - 1), listXYSeries.y(n4 - 1));
                }
                if ((n4 = (listXYSeries = data.EffVsKp(n6)).length()) > 0) {
                    Eff_plot.seriesDots(Dots.circle(5.0)).seriesColor(Color.black).xySeries(listXYSeries).label("<I>Kt</I> = " + n6, listXYSeries.x(n4 - 1), listXYSeries.y(n4 - 1));
                }
                if ((n4 = (listXYSeries = data.EdsfVsKp(n6)).length()) <= 0) continue;
                EDSF_plot.seriesDots(Dots.circle(5.0)).seriesColor(Color.black).xySeries(listXYSeries).label("<I>Kt</I> = " + n6, listXYSeries.x(n4 - 1), listXYSeries.y(n4 - 1));
            }
            iterator = Kp_set.iterator();
            while (iterator.hasNext()) {
                int n7 = (Integer)iterator.next();
                ListXYSeries listXYSeries = data.TOverKt(n7);
                n4 = listXYSeries.length();
                if (n4 > 0) {
                    T_plot.seriesDots(null).seriesColor(Color.black).xySeries(listXYSeries);
                }
                if ((n4 = (listXYSeries = data.SpeedupOverKt(n7)).length()) > 0) {
                    Speedup_plot.seriesDots(null).seriesColor(Color.black).xySeries(listXYSeries);
                }
                if ((n4 = (listXYSeries = data.EffOverKt(n7)).length()) > 0) {
                    Eff_plot.seriesDots(null).seriesColor(Color.black).xySeries(listXYSeries);
                }
                if ((n4 = (listXYSeries = data.EdsfOverKt(n7)).length()) <= 0) continue;
                EDSF_plot.seriesDots(null).seriesColor(Color.black).xySeries(listXYSeries);
            }
        }
        T_plot.getFrame().setVisible(true);
        Speedup_plot.getFrame().setVisible(true);
        Eff_plot.getFrame().setVisible(true);
        EDSF_plot.getFrame().setVisible(true);
    }

    private static void parseLine(String string, int n) {
        Scanner scanner = new Scanner(string);
        if (scanner.hasNextInt()) {
            int n2;
            int n3;
            int n4 = scanner.nextInt();
            if (!scanner.hasNextInt()) {
                HybridSpeedup.error("Kp invalid", n);
            }
            if ((n3 = scanner.nextInt()) < 0) {
                HybridSpeedup.error("Kp < 0", n);
            }
            if (n3 > 0) {
                Kp_set.add(n3);
            }
            Kp_max = Math.max(Kp_max, (double)n3);
            if (!scanner.hasNextInt()) {
                HybridSpeedup.error("Kt invalid", n);
            }
            if ((n2 = scanner.nextInt()) < 0) {
                HybridSpeedup.error("Kt < 0", n);
            }
            if (n2 > 0) {
                Kt_set.add(n2);
            }
            Kt_max = Math.max(Kt_max, (double)n2);
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            while (scanner.hasNextLong()) {
                double d3 = scanner.nextLong();
                if (d3 <= 0.0) {
                    HybridSpeedup.error("T invalid", n);
                }
                d = Math.min(d, d3);
                d2 = Math.max(d2, d3);
            }
            if (d == Double.POSITIVE_INFINITY) {
                HybridSpeedup.error("T values missing", n);
            }
            Data data = HybridSpeedup.getData(n4);
            data.entries.add(new DataEntry(n3, n2, d, d2));
        } else {
            String string2 = scanner.next();
            if (string2.equals("n")) {
                if (!scanner.hasNextInt()) {
                    HybridSpeedup.error("Missing n value", n);
                }
                int n5 = scanner.nextInt();
                if (!scanner.hasNextDouble()) {
                    HybridSpeedup.error("Missing N value", n);
                }
                double d = scanner.nextDouble();
                String string3 = scanner.findInLine(QUOTED_STRING_PATTERN);
                if (string3 == null) {
                    HybridSpeedup.error("Missing quoted label text", n);
                }
                string3 = string3.substring(1, string3.length() - 1);
                Data data = HybridSpeedup.getData(n5);
                data.N = d;
                data.labelText = string3;
            } else if (string2.equals("time")) {
                HybridSpeedup.parsePlotSpecification(T_plot, scanner, n);
            } else if (string2.equals("speedup")) {
                HybridSpeedup.parsePlotSpecification(Speedup_plot, scanner, n);
            } else if (string2.equals("eff")) {
                HybridSpeedup.parsePlotSpecification(Eff_plot, scanner, n);
            } else if (string2.equals("edsf")) {
                HybridSpeedup.parsePlotSpecification(EDSF_plot, scanner, n);
            } else {
                HybridSpeedup.error("Unknown command", n);
            }
        }
    }

    private static void parsePlotSpecification(Plot plot, Scanner scanner, int n) {
        String string;
        if (!scanner.hasNext()) {
            HybridSpeedup.error("Missing plot attribute", n);
        }
        if ((string = scanner.next()).equals("frameTitle")) {
            String string2 = scanner.findInLine(QUOTED_STRING_PATTERN);
            if (string2 == null) {
                HybridSpeedup.error("Missing quoted frame title", n);
            }
            string2 = string2.substring(1, string2.length() - 1);
            plot.frameTitle(string2);
        } else if (string.equals("plotTitle")) {
            String string3 = scanner.findInLine(QUOTED_STRING_PATTERN);
            if (string3 == null) {
                HybridSpeedup.error("Missing quoted plot title", n);
            }
            string3 = string3.substring(1, string3.length() - 1);
            plot.plotTitle(string3);
        } else if (string.equals("margins")) {
            if (!scanner.hasNextDouble()) {
                HybridSpeedup.error("Missing margins value", n);
            }
            double d = scanner.nextDouble();
            plot.margins(d);
        } else if (string.equals("leftMargin")) {
            if (!scanner.hasNextDouble()) {
                HybridSpeedup.error("Missing left margin value", n);
            }
            double d = scanner.nextDouble();
            plot.leftMargin(d);
        } else if (string.equals("topMargin")) {
            if (!scanner.hasNextDouble()) {
                HybridSpeedup.error("Missing top margin value", n);
            }
            double d = scanner.nextDouble();
            plot.topMargin(d);
        } else if (string.equals("rightMargin")) {
            if (!scanner.hasNextDouble()) {
                HybridSpeedup.error("Missing right margin value", n);
            }
            double d = scanner.nextDouble();
            plot.rightMargin(d);
        } else if (string.equals("bottomMargin")) {
            if (!scanner.hasNextDouble()) {
                HybridSpeedup.error("Missing bottom margin value", n);
            }
            double d = scanner.nextDouble();
            plot.bottomMargin(d);
        } else if (string.equals("xAxisStart")) {
            if (!scanner.hasNextDouble()) {
                HybridSpeedup.error("Missing X axis start value", n);
            }
            double d = scanner.nextDouble();
            plot.xAxisStart(d);
        } else if (string.equals("xAxisEnd")) {
            if (!scanner.hasNextDouble()) {
                HybridSpeedup.error("Missing X axis end value", n);
            }
            double d = scanner.nextDouble();
            plot.xAxisEnd(d);
        } else if (string.equals("xAxisMajorDivisions")) {
            if (!scanner.hasNextInt()) {
                HybridSpeedup.error("Missing X axis major divisions value", n);
            }
            int n2 = scanner.nextInt();
            plot.xAxisMajorDivisions(n2);
        } else if (string.equals("xAxisMinorDivisions")) {
            if (!scanner.hasNextInt()) {
                HybridSpeedup.error("Missing X axis minor divisions value", n);
            }
            int n3 = scanner.nextInt();
            plot.xAxisMinorDivisions(n3);
        } else if (string.equals("xAxisLength")) {
            if (!scanner.hasNextDouble()) {
                HybridSpeedup.error("Missing X axis length value", n);
            }
            double d = scanner.nextDouble();
            plot.xAxisLength(d);
        } else if (string.equals("xAxisTitle")) {
            String string4 = scanner.findInLine(QUOTED_STRING_PATTERN);
            if (string4 == null) {
                HybridSpeedup.error("Missing quoted X axis title", n);
            }
            string4 = string4.substring(1, string4.length() - 1);
            plot.xAxisTitle(string4);
        } else if (string.equals("yAxisStart")) {
            if (!scanner.hasNextDouble()) {
                HybridSpeedup.error("Missing Y axis start value", n);
            }
            double d = scanner.nextDouble();
            plot.yAxisStart(d);
        } else if (string.equals("yAxisEnd")) {
            if (!scanner.hasNextDouble()) {
                HybridSpeedup.error("Missing Y axis end value", n);
            }
            double d = scanner.nextDouble();
            plot.yAxisEnd(d);
        } else if (string.equals("yAxisMajorDivisions")) {
            if (!scanner.hasNextInt()) {
                HybridSpeedup.error("Missing Y axis major divisions value", n);
            }
            int n4 = scanner.nextInt();
            plot.yAxisMajorDivisions(n4);
        } else if (string.equals("yAxisMinorDivisions")) {
            if (!scanner.hasNextInt()) {
                HybridSpeedup.error("Missing Y axis minor divisions value", n);
            }
            int n5 = scanner.nextInt();
            plot.yAxisMinorDivisions(n5);
        } else if (string.equals("yAxisTickFormat")) {
            String string5 = scanner.findInLine(QUOTED_STRING_PATTERN);
            if (string5 == null) {
                HybridSpeedup.error("Missing quoted Y axis tick format", n);
            }
            string5 = string5.substring(1, string5.length() - 1);
            plot.yAxisTickFormat(new DecimalFormat(string5));
        } else if (string.equals("yAxisLength")) {
            if (!scanner.hasNextDouble()) {
                HybridSpeedup.error("Missing Y axis length value", n);
            }
            double d = scanner.nextDouble();
            plot.yAxisLength(d);
        } else if (string.equals("yAxisTitle")) {
            String string6 = scanner.findInLine(QUOTED_STRING_PATTERN);
            if (string6 == null) {
                HybridSpeedup.error("Missing quoted Y axis title", n);
            }
            string6 = string6.substring(1, string6.length() - 1);
            plot.yAxisTitle(string6);
        } else if (string.equals("yAxisTitleOffset")) {
            if (!scanner.hasNextDouble()) {
                HybridSpeedup.error("Missing Y axis title offset value", n);
            }
            double d = scanner.nextDouble();
            plot.yAxisTitleOffset(d);
        } else {
            HybridSpeedup.error("Unknown plot attribute", n);
        }
    }

    private static Data getData(int n) {
        Data data = dataMap.get(n);
        if (data == null) {
            data = new Data(n);
            dataMap.put(n, data);
        }
        return data;
    }

    private static void error(String string, int n) {
        System.err.println("Error: line " + n + ": " + string);
        System.exit(1);
    }

    private static void usage() {
        System.err.println("Usage: java Speedup <inputfile>");
        System.exit(1);
    }

    private static class Data {
        public int n;
        public double N;
        public String labelText;
        public ArrayList<DataEntry> entries = new ArrayList();

        public Data(int n) {
            this.n = n;
            this.N = n;
            this.labelText = "N = " + n;
        }

        public boolean validate() {
            return this.entries.contains(new DataEntry(1, 1, 0.0, 0.0));
        }

        public ListXYSeries TVsKp(int n) {
            ListXYSeries listXYSeries = new ListXYSeries();
            for (DataEntry dataEntry : this.entries) {
                if (dataEntry.Kt != n) continue;
                listXYSeries.add((double)dataEntry.Kp, dataEntry.T);
            }
            return listXYSeries;
        }

        public ListXYSeries TOverKt(int n) {
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            ListXYSeries listXYSeries = new ListXYSeries();
            for (DataEntry dataEntry : this.entries) {
                if (dataEntry.Kp != n) continue;
                d = Math.min(d, dataEntry.T);
                d2 = Math.max(d2, dataEntry.T);
            }
            listXYSeries.add((double)n, d);
            listXYSeries.add((double)n, d2);
            return listXYSeries;
        }

        public ListXYSeries SpeedupVsKp(int n) {
            double d = 0.0;
            ListXYSeries listXYSeries = new ListXYSeries();
            for (DataEntry dataEntry : this.entries) {
                if (dataEntry.Kp == 0) {
                    d = dataEntry.T;
                } else if (d == 0.0 && dataEntry.Kp == 1 && dataEntry.Kt == 1) {
                    d = dataEntry.T;
                }
                if (dataEntry.Kt != n) continue;
                double d2 = d / dataEntry.T;
                listXYSeries.add((double)dataEntry.Kp, d2);
            }
            return listXYSeries;
        }

        public ListXYSeries SpeedupOverKt(int n) {
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            double d3 = 0.0;
            ListXYSeries listXYSeries = new ListXYSeries();
            for (DataEntry dataEntry : this.entries) {
                if (dataEntry.Kp == 0) {
                    d3 = dataEntry.T;
                } else if (d3 == 0.0 && dataEntry.Kp == 1 && dataEntry.Kt == 1) {
                    d3 = dataEntry.T;
                }
                if (dataEntry.Kp != n) continue;
                double d4 = d3 / dataEntry.T;
                d = Math.min(d, d4);
                d2 = Math.max(d2, d4);
            }
            listXYSeries.add((double)n, d);
            listXYSeries.add((double)n, d2);
            return listXYSeries;
        }

        public ListXYSeries EffVsKp(int n) {
            double d = 0.0;
            ListXYSeries listXYSeries = new ListXYSeries();
            for (DataEntry dataEntry : this.entries) {
                if (dataEntry.Kp == 0) {
                    d = dataEntry.T;
                } else if (d == 0.0 && dataEntry.Kp == 1 && dataEntry.Kt == 1) {
                    d = dataEntry.T;
                }
                if (dataEntry.Kt != n) continue;
                double d2 = d / dataEntry.T;
                double d3 = d2 / (double)dataEntry.Kp / (double)dataEntry.Kt;
                listXYSeries.add((double)dataEntry.Kp, d3);
            }
            return listXYSeries;
        }

        public ListXYSeries EffOverKt(int n) {
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            double d3 = 0.0;
            ListXYSeries listXYSeries = new ListXYSeries();
            for (DataEntry dataEntry : this.entries) {
                if (dataEntry.Kp == 0) {
                    d3 = dataEntry.T;
                } else if (d3 == 0.0 && dataEntry.Kp == 1 && dataEntry.Kt == 1) {
                    d3 = dataEntry.T;
                }
                if (dataEntry.Kp != n) continue;
                double d4 = d3 / dataEntry.T;
                double d5 = d4 / (double)dataEntry.Kp / (double)dataEntry.Kt;
                d = Math.min(d, d5);
                d2 = Math.max(d2, d5);
            }
            listXYSeries.add((double)n, d);
            listXYSeries.add((double)n, d2);
            return listXYSeries;
        }

        public ListXYSeries EdsfVsKp(int n) {
            double d = 0.0;
            ListXYSeries listXYSeries = new ListXYSeries();
            for (DataEntry dataEntry : this.entries) {
                int n2;
                if (dataEntry.Kp == 1 && dataEntry.Kt == 1) {
                    d = dataEntry.T;
                }
                if ((n2 = dataEntry.Kp * dataEntry.Kt) <= 1 || dataEntry.Kt != n) continue;
                double d2 = (dataEntry.T * (double)n2 - d) / d / (double)(n2 - 1);
                listXYSeries.add((double)dataEntry.Kp, d2);
            }
            return listXYSeries;
        }

        public ListXYSeries EdsfOverKt(int n) {
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            double d3 = 0.0;
            ListXYSeries listXYSeries = new ListXYSeries();
            for (DataEntry dataEntry : this.entries) {
                int n2;
                if (dataEntry.Kp == 1 && dataEntry.Kt == 1) {
                    d3 = dataEntry.T;
                }
                if ((n2 = dataEntry.Kp * dataEntry.Kt) <= 1 || dataEntry.Kp != n) continue;
                double d4 = (dataEntry.T * (double)n2 - d3) / d3 / (double)(n2 - 1);
                d = Math.min(d, d4);
                d2 = Math.max(d2, d4);
            }
            listXYSeries.add((double)n, d);
            listXYSeries.add((double)n, d2);
            return listXYSeries;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DataEntry
    implements Comparable<DataEntry> {
        public int Kp;
        public int Kt;
        public double T;
        public double T_max;

        public DataEntry(int n, int n2, double d, double d2) {
            this.Kp = n;
            this.Kt = n2;
            this.T = d;
            this.T_max = d2;
        }

        public boolean equals(Object object) {
            return object instanceof DataEntry && ((DataEntry)object).Kp == this.Kp && ((DataEntry)object).Kt == this.Kt;
        }

        public int hashCode() {
            return this.Kp << 16 | this.Kt;
        }

        @Override
        public int compareTo(DataEntry dataEntry) {
            return this.Kp != dataEntry.Kp ? this.Kp - dataEntry.Kp : this.Kt - dataEntry.Kt;
        }
    }
}

