## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ---- eval = FALSE------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE)) {
#      install.packages("BiocManager")
#  }
#  BiocManager::install("consICA")

## ---- echo=T, results = 'hide'------------------------------------------------
library('consICA')

## -----------------------------------------------------------------------------
library(SummarizedExperiment, verbose = FALSE)
data("samples_data")

samples_data
# According to our terminology expression matrix X of 2454 genes and 472 samples
X <- data.frame(assay(samples_data))
dim(X)
# variables described each sample
Var <- data.frame(colData(samples_data))
dim(Var)
colnames(Var)[1:20] # print first 20
# survival time and event for each sample
Sur <- data.frame(colData(samples_data))[,c("time", "event")]
Var <- Var[,-which(colnames(Var) != "time" & colnames(Var) != "event")]


## ----echo=FALSE, out.width='95%', fig.align="center"--------------------------
knitr::include_graphics('./Picture1.jpg')

## -----------------------------------------------------------------------------
set.seed(2022)
cica <- consICA(samples_data, ncomp=40, ntry=10, show.every=0)

## -----------------------------------------------------------------------------
str(cica, max.level=1)

## -----------------------------------------------------------------------------
features <- getFeatures(cica, alpha = 0.05, sort = TRUE)
#Positive and negative affecting features for first components are
head(features$ic.1$pos)
head(features$ic.1$neg)

## -----------------------------------------------------------------------------
icomp <- 1
plot(sort(cica$S[,icomp]),col = "#0000FF", type="l", ylab=("involvement"),xlab="genes",las=2,cex.axis=0.4, main=paste0("Metagene #", icomp, "\n(involvement of features)"),cex.main=0.6)

## -----------------------------------------------------------------------------
var_ic <- estimateVarianceExplained(cica)
p <- plotICVarianceExplained(cica)

## ---- results='hide'----------------------------------------------------------
## To save time for this example load result of getGO(cica, alpha = 0.05, db = c("BP", "MF", "CC"))
if(!file.exists("GOs_40_s2022.rds")){
  GOs <- readRDS(url("http://edu.modas.lu/data/consICA/GOs_40_s2022.rds", "r"))
  saveRDS(GOs, "GOs_40_s2022.rds")
} else{
    GOs <- readRDS("GOs_40_s2022.rds")
}
## Search GO (biological process)
# GOs <- getGO(cica, alpha = 0.05, db = "BP")
## Search GO (biological process, molecular function, cellular component)
# GOs <- getGO(cica, alpha = 0.05, db = c("BP", "MF", "CC"))

## -----------------------------------------------------------------------------
RS <- survivalAnalysis(cica, surv = Sur)
cat("Hazard score for significant components")
RS$hazard.score

## -----------------------------------------------------------------------------
# Generate report with independent components description
if(FALSE){
  saveReport(cica, GO=GOs, Var=Var, surv = Sur)
}

## -----------------------------------------------------------------------------
# delete loaded file after vignette run
unlink("GOs_40_s2022.rds")

## -----------------------------------------------------------------------------
sessionInfo()

