## ---- setup, include=FALSE----------------------------------------------------
knitr::opts_chunk$set(cache = TRUE)

## ----include=TRUE,results="hide",message=FALSE,warning=FALSE------------------
library(cBioPortalData)
library(AnVIL)

## -----------------------------------------------------------------------------
(cbio <- cBioPortal())

## -----------------------------------------------------------------------------
tags(cbio)
head(tags(cbio)$operation)

## -----------------------------------------------------------------------------
searchOps(cbio, "clinical")

## -----------------------------------------------------------------------------
getStudies(cbio)

## -----------------------------------------------------------------------------
clinicalData(cbio, "acc_tcga")

## -----------------------------------------------------------------------------
mols <- molecularProfiles(cbio, "acc_tcga")
mols[["molecularProfileId"]]

## -----------------------------------------------------------------------------
molecularData(cbio, molecularProfileId = "acc_tcga_rna_seq_v2_mrna",
    entrezGeneIds = c(1, 2),
    sampleIds = c("TCGA-OR-A5J1-01",  "TCGA-OR-A5J2-01")
)

## -----------------------------------------------------------------------------
geneTable(cbio)

## -----------------------------------------------------------------------------
genePanels(cbio)
getGenePanel(cbio, "IMPACT341")

## -----------------------------------------------------------------------------
gprppa <- genePanelMolecular(cbio,
    molecularProfileId = "acc_tcga_rppa",
    sampleListId = "acc_tcga_all")
gprppa

## -----------------------------------------------------------------------------
getGenePanelMolecular(cbio,
    molecularProfileIds = c("acc_tcga_rppa", "acc_tcga_gistic"),
    sampleIds = allSamples(cbio, "acc_tcga")$sampleId
)

## -----------------------------------------------------------------------------
getDataByGenes(cbio, "acc_tcga", genePanelId = "IMPACT341",
    molecularProfileId = "acc_tcga_rppa", sampleListId = "acc_tcga_rppa")

## -----------------------------------------------------------------------------
sampleLists(cbio, "acc_tcga")

## -----------------------------------------------------------------------------
samplesInSampleLists(cbio, "acc_tcga_cna")

## -----------------------------------------------------------------------------
samplesInSampleLists(cbio, c("acc_tcga_cna", "acc_tcga_cnaseq"))

## -----------------------------------------------------------------------------
allSamples(cbio, "acc_tcga")

## -----------------------------------------------------------------------------
getSampleInfo(cbio, studyId = "acc_tcga",
    sampleListIds = c("acc_tcga_rppa", "acc_tcga_gistic"))

## -----------------------------------------------------------------------------
cbio$getGeneUsingGET

## -----------------------------------------------------------------------------
(resp <- cbio$getGeneUsingGET("BRCA1"))

## -----------------------------------------------------------------------------
httr::content(resp)

## ----eval=FALSE---------------------------------------------------------------
#  unlink("~/.cache/cBioPortalData/")

## -----------------------------------------------------------------------------
sessionInfo()

