## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>", fig.align = "center"
)

## ---- eval=FALSE--------------------------------------------------------------
#  if (!requireNamespace("BiocManager")) install.packages("BiocManager")
#  BiocManager::install("Voyager")
#  # Devel version
#  # install.packages("remotes")
#  remotes::install_github("pachterlab/Voyager")

## -----------------------------------------------------------------------------
library(SFEData)
library(SpatialFeatureExperiment)
library(Voyager)
library(scater)

## -----------------------------------------------------------------------------
sfe <- McKellarMuscleData()
# Only use spots in tissue here
sfe <- sfe[,colData(sfe)$in_tissue]
sfe <- logNormCounts(sfe)
sfe

## -----------------------------------------------------------------------------
colGraph(sfe, "visium") <- findVisiumGraph(sfe)

## -----------------------------------------------------------------------------
features_use <- c("Myh1", "Myh2")

## -----------------------------------------------------------------------------
sfe <- runUnivariate(sfe, type = "moran", features = features_use, 
                     colGraphName = "visium")
# Look at the results
rowData(sfe)[rowData(sfe)$symbol %in% features_use,]

## -----------------------------------------------------------------------------
sfe <- runUnivariate(sfe, type = "localG", features = features_use,
                     colGraphName = "visium", include_self = TRUE)
# Look at the results
DataFrame(localResults(sfe, name = "localG"))

## -----------------------------------------------------------------------------
plotSpatialFeature(sfe, c("nCounts", "Myh1"), colGeometryName = "spotPoly", 
                   annotGeometryName = "myofiber_simplified", 
                   aes_use = "color", size = 0.4, fill = NA,
                   annot_aes = list(fill = "area"))

## -----------------------------------------------------------------------------
plotLocalResult(sfe, "localG", features = features_use, 
                colGeometryName = "spotPoly", divergent = TRUE, 
                diverge_center = 0)

## -----------------------------------------------------------------------------
sessionInfo()

