/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pdf.internal;

import java.awt.Font;
import org.jfree.pdf.util.Args;
import org.jfree.pdf.util.ObjectUtils;

public class FontKey {
    private String name;
    private boolean isBold;
    private boolean isItalic;

    public static FontKey createFontKey(Font f) {
        Args.nullNotPermitted(f, "f");
        String family = f.getFamily().replace(' ', '_');
        boolean bold = f.isBold();
        boolean italic = f.isItalic();
        return new FontKey(family, bold, italic);
    }

    public FontKey(String name, boolean bold, boolean italic) {
        this.name = name;
        this.isBold = bold;
        this.isItalic = italic;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FontKey other = (FontKey)obj;
        if (!ObjectUtils.equals(this.name, other.name)) {
            return false;
        }
        if (this.isBold != other.isBold) {
            return false;
        }
        return this.isItalic == other.isItalic;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + ObjectUtils.hashCode(this.name);
        hash = 97 * hash + (this.isBold ? 1 : 0);
        hash = 97 * hash + (this.isItalic ? 1 : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FontKey[name=").append(this.name);
        sb.append(",isBold=").append(this.isBold);
        sb.append(",isItalic=").append(this.isItalic);
        sb.append("]");
        return sb.toString();
    }
}

