## ----eval=FALSE---------------------------------------------------------------
#  if (!require("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  
#  BiocManager::install("RESOLVE")

## ----message=FALSE------------------------------------------------------------
library("RESOLVE")
data(ssm560_reduced)

## ----message=FALSE------------------------------------------------------------
library("BSgenome.Hsapiens.1000genomes.hs37d5")
imported_data = getSBSCounts(data = ssm560_reduced, reference = BSgenome.Hsapiens.1000genomes.hs37d5)
head(imported_data)

## ----fig.width=7, fig.height=7, fig.cap="Visualization of the counts for patient PD10010a from the dataset published in Nik-Zainal, Serena, et al."----
patientsSBSPlot(trinucleotides_counts=imported_data,samples="PD10010a")

## -----------------------------------------------------------------------------
data(background)
data(patients)
set.seed(12345)
res_denovo = signaturesDecomposition(x = patients[1:3,], 
                                     K = 3:4, 
                                     background_signature = background, 
                                     nmf_runs = 2, 
                                     sparsify = FALSE, 
                                     num_processes = 1)

## -----------------------------------------------------------------------------
set.seed(12345)
res_cv = signaturesCV(x = patients[1:3,], 
                      beta = res_denovo$beta, 
                      cross_validation_iterations = 2, 
                      cross_validation_repetitions = 2, 
                      num_processes = 1)

## ----fig.width=7, fig.height=7, fig.cap="Visualization of the discovered signatures."----
signatures = res_denovo$beta[[2]]
signaturesSBSPlot(beta=signatures, xlabels=FALSE)

## -----------------------------------------------------------------------------
sessionInfo()

