## ----style-knitr, eval=TRUE, echo=FALSE, results="asis"-----------------------------
BiocStyle::latex()

## -----------------------------------------------------------------------------------
library(OncoScore)

## ----eval=FALSE---------------------------------------------------------------------
#  query = perform.query(c("ASXL1","IDH1","IDH2","SETBP1","TET2"))

## ----include=FALSE,echo=FALSE-------------------------------------------------------
data(query)

## -----------------------------------------------------------------------------------
combine.query.results(query, c('IDH1', 'IDH2'), 'new_gene')

## ----eval=FALSE---------------------------------------------------------------------
#  chr13 = get.genes.from.biomart(chromosome=13,start=54700000,end=72800000)
#  head(chr13)

## ----eval=FALSE---------------------------------------------------------------------
#  result = compute.oncoscore.from.region(10, 100000, 500000)

## -----------------------------------------------------------------------------------
result = compute.oncoscore(query)

## ----eval=FALSE---------------------------------------------------------------------
#  query.timepoints = perform.query.timeseries(c("ASXL1","IDH1","IDH2","SETBP1","TET2"),
#      c("2012/03/01", "2013/03/01", "2014/03/01", "2015/03/01", "2016/03/01"))

## ----include=FALSE,echo=FALSE-------------------------------------------------------
data(query.timepoints)

## -----------------------------------------------------------------------------------
result.timeseries = compute.oncoscore.timeseries(query.timepoints)

## ----image-oncoscore, fig.show='hide', fig.width=5, fig.height=5, results='hide'----
plot.oncoscore(result, col = 'darkblue')

## ----image-timeseries, fig.show='hide', fig.width=5, fig.height=5, results='hide'----
plot.oncoscore.timeseries(result.timeseries)

## ----image-oncoscore-timeseries, fig.show='hide', fig.width=7, fig.height=5.5, results='hide'----
plot.oncoscore.timeseries(result.timeseries, 
    incremental = TRUE, 
    ylab='absolute variation')

## ----image-oncoscore-timeseries-incremental, fig.show='hide', fig.width=7, fig.height=6.5, results='hide'----
plot.oncoscore.timeseries(result.timeseries,
    incremental = TRUE,
    relative = TRUE,
    ylab='relative variation')

## ----sessioninfo, results='asis', echo=FALSE----------------------------------------
toLatex(sessionInfo())

