## ----style, echo = FALSE, results = 'asis'------------------------------------
library(BiocStyle)
BiocStyle::markdown()

## ----message = FALSE, warning = FALSE, echo = FALSE---------------------------
library(AnnotationHub)
library(MetaboAnnotation)
library(Spectra)

## ---- message = FALSE---------------------------------------------------------
library(MetaboAnnotation)

## ---- message = FALSE---------------------------------------------------------
ms1_features <- read.table(system.file("extdata", "MS1_example.txt",
                                       package = "MetaboAnnotation"),
                           header = TRUE, sep = "\t")
head(ms1_features)
target_df <- read.table(system.file("extdata", "LipidMaps_CompDB.txt",
                                    package = "MetaboAnnotation"),
                        header = TRUE, sep = "\t")
head(target_df)

## -----------------------------------------------------------------------------
parm <- Mass2MzParam(adducts = c("[M+H]+", "[M+Na]+"),
                           tolerance = 0.005, ppm = 0)

matched_features <- matchValues(ms1_features[1:100, ], target_df, parm)
matched_features

## -----------------------------------------------------------------------------
head(query(matched_features))
head(target(matched_features))

## -----------------------------------------------------------------------------
whichQuery(matched_features)
whichTarget(matched_features)

## -----------------------------------------------------------------------------
colnames(matched_features)

## -----------------------------------------------------------------------------
matchedData(matched_features)

## -----------------------------------------------------------------------------
matched_features$target_name

## -----------------------------------------------------------------------------
ms1_subset <- ms1_features[1:100, ]
head(ms1_subset)

## -----------------------------------------------------------------------------
set.seed(123)
target_df$rtime <- sample(ms1_subset$rtime,
                          nrow(target_df), replace = TRUE) + 2

## -----------------------------------------------------------------------------
parm <- Mass2MzRtParam(adducts = c("[M+H]+", "[M+Na]+"),
                       tolerance = 0.005, ppm = 0,
                       toleranceRt = 10)
matched_features <- matchValues(ms1_subset, target_df, param = parm,
                                rtColname = "rtime")
matched_features

## -----------------------------------------------------------------------------
matchedData(matched_features)[whichQuery(matched_features), ]

## -----------------------------------------------------------------------------
library(SummarizedExperiment)

se <- SummarizedExperiment(
    assays = matrix(nrow = nrow(ms1_features), ncol = 4),
    rowData = ms1_features)

## -----------------------------------------------------------------------------
parm <- Mass2MzParam(adducts = c("[M+H]+", "[M+Na]+"),
                     tolerance = 0.005, ppm = 0)
matched_features <- matchValues(se, target_df, param = parm)
matched_features

## -----------------------------------------------------------------------------
colnames(matched_features)
matchedData(matched_features)

## -----------------------------------------------------------------------------
matched_sub <- matched_features[whichQuery(matched_features)]
query(matched_sub)

## ---- warning = FALSE---------------------------------------------------------
library(QFeatures)
qf <- QFeatures(list(features = se))
qf

## -----------------------------------------------------------------------------
matched_qf <- matchValues(qf, target_df, param = parm, queryAssay = "features")
matched_qf

## -----------------------------------------------------------------------------
colnames(matched_qf)
matchedData(matched_qf)

## ---- message = FALSE---------------------------------------------------------
library(Spectra)
library(msdata)
fl <- system.file("TripleTOF-SWATH", "PestMix1_DDA.mzML", package = "msdata")
pest_ms2 <- filterMsLevel(Spectra(fl), 2L)
## subset to selected spectra.
pest_ms2 <- pest_ms2[c(808, 809, 945:955)]
## assign arbitrary *feature IDs* to each spectrum.
pest_ms2$feature_id <- c("FT001", "FT001", "FT002", "FT003", "FT003", "FT003",
                         "FT004", "FT004", "FT004", "FT005", "FT005", "FT006",
                         "FT006")
## assign also *spectra IDs* to each
pest_ms2$spectrum_id <- paste0("sp_", seq_along(pest_ms2))
pest_ms2

## -----------------------------------------------------------------------------
load(system.file("extdata", "minimb.RData", package = "MetaboAnnotation"))
minimb

## -----------------------------------------------------------------------------
mtches <- matchSpectra(pest_ms2, minimb,
                       param = CompareSpectraParam(requirePrecursor = TRUE,
                                                   ppm = 10))
mtches

## -----------------------------------------------------------------------------
mtches[1]

## -----------------------------------------------------------------------------
mtches[2]

## -----------------------------------------------------------------------------
spectraVariables(mtches)

## -----------------------------------------------------------------------------
mtches[2]$target_compound_name

## -----------------------------------------------------------------------------
mtches$spectrum_id

## -----------------------------------------------------------------------------
mtches_df <- spectraData(mtches, columns = c("spectrum_id", "feature_id",
                                             "score", "target_spectrum_id",
                                             "target_compound_name"))
as.data.frame(mtches_df)

## -----------------------------------------------------------------------------
plotSpectraMirror(mtches[2])

## -----------------------------------------------------------------------------
scale_int <- function(x) {
    x[, "intensity"] <- x[, "intensity"] / max(x[, "intensity"], na.rm = TRUE)
    x
}
mtches <- addProcessing(mtches, scale_int)
plotSpectraMirror(mtches[2])

## -----------------------------------------------------------------------------
mtches[2]$target_compound_name

## -----------------------------------------------------------------------------
mp <- MatchForwardReverseParam(requirePrecursor = TRUE, ppm = 10)
mtches <- matchSpectra(pest_ms2, minimb, param = mp)
mtches

## -----------------------------------------------------------------------------
as.data.frame(
    spectraData(mtches, c("spectrum_id", "target_spectrum_id",
                          "target_compound_name", "score", "reverse_score",
                          "presence_ratio")))

## -----------------------------------------------------------------------------
select_top_match <- function(x) {
    which.max(x)
}
csp <- CompareSpectraParam(ppm = 10, requirePrecursor = FALSE,
                           THRESHFUN = select_top_match)
mtches <- matchSpectra(pest_ms2, minimb, param = csp)
res <- spectraData(mtches, columns = c("spectrum_id", "target_spectrum_id",
                                       "target_compound_name", "score"))
as.data.frame(res)

## ---- message = FALSE---------------------------------------------------------
mbank <- MassBankSource("2022.06")
mbank

## -----------------------------------------------------------------------------
res <- matchSpectra(
    pest_ms2, mbank,
    param = CompareSpectraParam(requirePrecursor = TRUE, ppm = 10))
res

## -----------------------------------------------------------------------------
target(res)

## -----------------------------------------------------------------------------
matchedData(res)$target_name

## ----sessioninfo, echo=FALSE--------------------------------------------------
sessionInfo()

